/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*
import java.text.SimpleDateFormat

final def apTool = new AirPluginTool(args[0], args[1])
def DateParser dateParser = new DateParser()

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------

final def  workDir           = new File('.').canonicalFile
final File resourceHome      = new File(System.getenv()['PLUGIN_HOME'])
final def  props             = apTool.getStepProperties()

final def client             = props['source/client']
final boolean isLoggingIn    = Boolean.valueOf(props['source/isLoggingIn'])
final def commandPath        = props['source/repo/commandPath'] ?: 'p4'
final def port               = props['source/repo/port']
final def username           = props['source/repo/username']
final def password           = props['source/repo/password'] ?: props['source/repo/passScript']
final def charset            = props['source/repo/charset']
final def commandCharset     = props['source/repo/commandCharset']

final def userExcludes       = props['source/excludeUsers']
final def fileFilters        = props['source/fileFilters']

final def integrateOption    = Boolean.valueOf(props['source/integrateOption'])

final def dir                = new File(workDir, props['source/dirOffset']).canonicalFile

final def startDate          = dateParser.parseDate(props['startDate']).getTime()
final def endDate            = dateParser.parseDate(props['endDate']).getTime()
final def persistToDB        = Boolean.valueOf(props['persistingChanges'])
final def changesUrl         = props['changesUrl']

dir.mkdirs()

SCMChangelog changelog = new SCMChangelog();
// Login info
changelog.scmCommand = commandPath
changelog.isLoggingIn = isLoggingIn
changelog.client = client
changelog.port = port
changelog.username = username
changelog.password = password
changelog.charset = charset
changelog.commandCharset = commandCharset

// Changelog Info
changelog.startDate = startDate
changelog.endDate = endDate
changelog.changeSetFilter.setUserExcludes(userExcludes);
changelog.changeSetFilter.setFileFilters(fileFilters);
changelog.changesUrl = changesUrl
changelog.integrateOption = integrateOption

changelog.workDir = dir

changelog.execute()