/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

final def apTool = new AirPluginTool(args[0], args[1])
final DateParser dateParser = new DateParser()
//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------

final def  workDir                   = new File('.').canonicalFile
final def  out                       = System.out
final File resourceHome              = new File(System.getenv()['PLUGIN_HOME'])
final def  props                     = apTool.getStepProperties()

final def srcName                    = props['source']
final def client                     = props['source/client']
final boolean isLoggingIn            = Boolean.valueOf(props['source/isLoggingIn'])
final def commandPath                = props['source/repo/commandPath'] ?: 'p4'
final def port                       = props['source/repo/port']
final def username                   = props['source/repo/username']
final def password                   = props['source/repo/password'] ?: props['source/repo/passScript']
final def charset                    = props['source/repo/charset']
final def commandCharset             = props['source/repo/commandCharset']

final boolean isUsingTemplate        = props['source/clientSpecPolicy'] == 'template'
final boolean createNewClientSpec    = props['source/clientSpecPolicy'] == 'literal'
final def templateName               = isUsingTemplate ? props['source/clientspecTemplateName'] : null
final def clientspec                 = props['source/clientspec']

final def userExcludes               = props['source/excludeUsers']
final def fileFilters                = props['source/fileFilters']

final def integrateOption            = Boolean.valueOf(props['source/integrateOption'])

final def dir                        = new File(workDir, props['source/dirOffset']).canonicalFile

// start and end dates
final def startDate                  = dateParser.parseDate(props['startDate']).getTime()
final def endDate                    = dateParser.parseDate(props['endDate']).getTime()

Date latestChangeDate = null

dir.mkdirs()

SCMQuietPeriod qp = new SCMQuietPeriod()
// Login info
qp.scmCommand = commandPath
qp.isLoggingIn = isLoggingIn
qp.client = client
qp.port = port
qp.username = username
qp.password = password
qp.charset = charset
qp.commandCharset = commandCharset
qp.createNewClientSpec = createNewClientSpec
qp.isUsingTemplate = isUsingTemplate
qp.templateName = templateName
qp.clientspec = clientspec

// Changelog Info
qp.startDate = startDate
qp.endDate = endDate
qp.changeSetFilter.setUserExcludes(userExcludes);
qp.changeSetFilter.setFileFilters(fileFilters);
qp.integrateOption = integrateOption

qp.workDir = dir

latestChangeDate = qp.execute()

//------------------------------------------------------------------------------
// UPLOAD LATEST CHANGE DATE
//------------------------------------------------------------------------------
if (latestChangeDate == null) {
    println('No changes detected')
}
else {
    apTool.setOutputProperty("job/latest.change.time.${srcName}", String.valueOf(latestChangeDate.time))
    apTool.storeOutputProperties()
    println "Latest Revision Date: " + latestChangeDate
}