package com.urbancode.air.plugin.scm

import java.util.Date;

import com.urbancode.air.*

public class SCMStep {
    
    //**************************************************************************
    // CLASS
    //**************************************************************************
    static protected final String REPO_TYPE = 'perforce'

    //**************************************************************************
    // INSTANCE
    //**************************************************************************

    def out = System.out
    
    String scmCommand = "p4"
    File workDir = new File(".").canonicalFile
    boolean isLoggingIn = false
    File ticketFile
    String username
    String password
    String charset
    String commandCharset
    String client
    String port
    def dirOffset
    
    CommandHelper ch = new CommandHelper(workDir);
    
    public void login() {
        if (isLoggingIn && needsLogin()) {
            def loginCmd = createP4BaseLoginCommand()
            loginCmd << "login"
            ch.runCommand('P4 Login', loginCmd) { proc ->
                if (password) {
                    proc.out << password
                }
                proc.out.close()
                proc.consumeProcessOutput(out, out) // forward stdout and stderr
            }
        }
    }
    
    public boolean needsLogin() {
//        // Check if we need a login
//        String statusOutput
//        def expired
//        
//        def loginStatusCommand = createP4BaseLoginCommand()
//        loginStatusCommand << "login" << "-s"
//        
//        try {
//            ch.runCommand("Checking P4 ticket status...", loginStatusCommand) { proc ->
//                proc.out.close()
//                proc.consumeProcessErrorStream(out)
//                statusOutput = proc.text
//                println statusOutput
//            }
//            // This is the only time we don't need to log in. Messages include:
//            // User (username) ticket expires in (hour) hours (min) minutes.
//            // Your session has expired, please login again.
//            // User (username) was authenticated by password not ticket.
//            
//            expired = statusOutput.find(~'^User .* ticket expires in [0-9][0-9] hours [0-9][0-9] minutes\\.$') { match -> return match}
//        }
//        catch (ExitCodeException e) {
//            // Perforce password (P4PASSWD) invalid or unset. 
//        }
//        return expired ? false : true
        return true;
    }
    
    /**
    * Create a the list of initial arguments needed for perforce commands
    */
    def createP4BaseLoginCommand = {
        def command =  [scmCommand]
        command << '-p' << port << '-u' << username
        return command
    }
    
    def createP4BaseCommand = {
        def command =  [scmCommand]
        
        if (client) {
            command << '-c' << client
        }
        
        command << '-p' << port << '-u' << username

        if (password && !isLoggingIn) {
            command << '-P' << password
        }
        if (charset) {
            command << '-C' << charset
        }
        if (commandCharset) {
            command << '-Q' << commandCharset
        }
        return command
    }
}