import com.urbancode.air.*
import com.urbancode.air.plugin.scm.*

final def apTool = new AirPluginTool(args[0], args[1])

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS
//------------------------------------------------------------------------------

final def  workDir                   = new File('.').canonicalFile
final File resourceHome              = new File(System.getenv()['PLUGIN_HOME'])
final def  props                     = apTool.getStepProperties();

final def srcId                      = props['source']
final def client                     = props['source/client']
final boolean isLoggingIn            = Boolean.valueOf(props['source/isLoggingIn'])
final def commandPath                = props['source/repo/commandPath'] ?: 'p4'
final def port                       = props['source/repo/port']
final def username                   = props['source/repo/username']
final def password                   = props['source/repo/password'] ?: props['source/repo/passScript']
final def charset                    = props['source/repo/charset']
final def commandCharset             = props['source/repo/commandCharset']

final boolean isUsingTemplate        = props['source/clientSpecPolicy'] == 'template'
final boolean createNewClientSpec    = props['source/clientSpecPolicy'] == 'literal'
final def templateName               = isUsingTemplate ? props['source/clientspecTemplateName'] : null
final def clientspec                 = props['source/clientspec']

final boolean forceSync              = Boolean.valueOf(props['source/isForceSync'])
final def label                      = props['source/label']
final boolean preserveUnlabeledFiles = Boolean.valueOf(props['source/preserveFilesWithoutLabel'])
final boolean doNotUpdateHaveList    = Boolean.valueOf(props['source/doNotUpdateHaveList'])
final def dir                        = new File(workDir, props['source/dirOffset']).canonicalFile

def date                             = props['date']?.toLong()
if (date) {
    date = new Date(date)
}

dir.mkdirs()

SCMCheckout co = new SCMCheckout()
// Command Info
co.scmCommand = commandPath
co.isLoggingIn = isLoggingIn
co.client = client
co.port = port
co.username = username
co.password = password
co.charset = charset
co.commandCharset = commandCharset

// Clientspec Info
co.isUsingTemplate = isUsingTemplate
co.createNewClientSpec = createNewClientSpec
co.templateName = templateName
co.clientspec = clientspec

// Sync Info
co.forceSync = forceSync
co.label = label
co.preserveUnlabeledFiles = preserveUnlabeledFiles
co.doNotUpdateHaveList = doNotUpdateHaveList

co.workDir = dir
co.date = date

String depotPaths = co.execute()

apTool.setOutputProperty("buildlife/perforce.depotPaths.${srcId}", depotPaths)

apTool.storeOutputProperties()