import com.urbancode.air.*

final def apTool = new AirPluginTool(args[0], args[1])

//------------------------------------------------------------------------------
// GET ALL INPUT PARAMETERS 
//------------------------------------------------------------------------------

final def  workDir        = new File('.').canonicalFile
final File resourceHome   = new File(System.getenv()['PLUGIN_HOME'])
final def  props          = apTool.getStepProperties()
final def dir             = new File(workDir, props['source/dirOffset'] ?: '.').canonicalFile // get checkout directory

 println "Deleting directory contents for $dir"
 dir.listFiles().each{ file ->
     boolean success = false;
     if (file.isFile()) {
         success = file.delete()
     }
     else if (file.isDirectory()){
         success = file.deleteDir()
     }
     if (!success) {
         println("Failed to delete $file")
     }
 }
 println "Done deleting directory contents for $dir"