/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.fileserver.protocol;

import com.urbancode.commons.util.Check;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProtocolCode {
    EOF(-1),
    HELLO("HELO"),
    ACK_HELLO("AHLO"),
    FILE("FILE"),
    END_FILES("EFLS"),
    ACK_END_FILES("AEFL"),
    CLOSE("CLOS"),
    ACK_CLOSE("ACLS"),
    RECV("RECV"),
    REMOTE_ERROR("RERR"),
    LOCAL_ERROR("LERR"),
    DELIVER("DLIV"),
    PATH_SET("PSET");

    private static final int[] sortedCodes;
    private static final ProtocolCode[] instancesSortedByCode;
    private final int code;

    public static ProtocolCode fromInt(int code) throws IOException {
        int index = Arrays.binarySearch(sortedCodes, code);
        if (index < 0) {
            throw new IOException("Invalid message code: " + code);
        }
        return instancesSortedByCode[index];
    }

    public static boolean isValidCode(int code) {
        return Arrays.binarySearch(sortedCodes, code) >= 0;
    }

    public static String decode(int code) {
        char[] buffer = new char[]{(char)(code >> 24 & 0xFF), (char)(code >> 16 & 0xFF), (char)(code >> 8 & 0xFF), (char)(code >> 0 & 0xFF)};
        return new String(buffer);
    }

    private static int encode(String code) {
        char[] buffer;
        int result = 0;
        Check.nonNull((Object)code, (String)"code");
        if (code.length() != 4) {
            throw new IllegalArgumentException("Invalid code length");
        }
        for (char c : buffer = code.toCharArray()) {
            if (c >= 'A' && c <= 'Z') continue;
            throw new IllegalArgumentException("Invalid code character");
        }
        result |= buffer[0] << 24;
        result |= buffer[1] << 16;
        result |= buffer[2] << 8;
        return result |= buffer[3] << 0;
    }

    private ProtocolCode(int code) {
        this.code = code;
    }

    private ProtocolCode(String string2) {
        this(ProtocolCode.encode(string2));
    }

    public int toInt() {
        return this.code;
    }

    static {
        Comparator<ProtocolCode> comparator = new Comparator<ProtocolCode>(){

            @Override
            public int compare(ProtocolCode l, ProtocolCode r) {
                Integer lCode = l.toInt();
                Integer rCode = r.toInt();
                return lCode.compareTo(rCode);
            }
        };
        instancesSortedByCode = ProtocolCode.values();
        sortedCodes = new int[instancesSortedByCode.length];
        Arrays.sort(instancesSortedByCode, comparator);
        for (int i = 0; i < instancesSortedByCode.length; ++i) {
            ProtocolCode.sortedCodes[i] = instancesSortedByCode[i].toInt();
        }
    }
}

