/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.urbancode.commons.util.Check;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.Marshaller;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListMarshaller<T>
extends MarshallerBase<List<T>> {
    private final Marshaller<T> elementMarshaller;

    public ListMarshaller(Marshaller<T> elementMarshaller) {
        Check.nonNull(elementMarshaller, (String)"elementMarshaller");
        this.elementMarshaller = elementMarshaller;
    }

    @Override
    JsonElement nonNullMarshal(List<T> value) {
        JsonArray result = new JsonArray();
        for (T v : value) {
            result.add(this.elementMarshaller.marshal(v));
        }
        return result;
    }

    @Override
    List<T> nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        ArrayList<T> result = new ArrayList<T>();
        JsonArray array = this.asJsonArray(element);
        for (JsonElement e : array) {
            result.add(this.elementMarshaller.unmarshal(e));
        }
        return result;
    }
}

