/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.urbancode.commons.util.Check;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.Marshaller;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapMarshaller<V>
extends MarshallerBase<Map<String, V>> {
    private final Marshaller<V> valueMarshaller;

    public MapMarshaller(Marshaller<V> valueMarshaller) {
        Check.nonNull(valueMarshaller, (String)"valueMarshaller");
        this.valueMarshaller = valueMarshaller;
    }

    @Override
    JsonElement nonNullMarshal(Map<String, V> value) {
        JsonObject result = new JsonObject();
        for (Map.Entry<String, V> e : value.entrySet()) {
            String key = e.getKey();
            if (key == null) {
                throw new NullPointerException("value contains null key");
            }
            result.add(key, this.valueMarshaller.marshal(e.getValue()));
        }
        return result;
    }

    @Override
    Map<String, V> nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        HashMap result = new HashMap();
        JsonObject object = this.asJsonObject(element);
        for (Map.Entry e : object.entrySet()) {
            result.put(e.getKey(), this.valueMarshaller.unmarshal((JsonElement)e.getValue()));
        }
        return result;
    }
}

