/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.model;

import com.urbancode.commons.util.Check;
import com.urbancode.ubuild.preflight.model.PathOffset;
import com.urbancode.ubuild.preflight.model.SyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathPattern {
    public static final PathPattern ALL;
    private final String pattern;

    public static List<PathPattern> toPathPatterns(String ... patterns) throws PathPatternSyntaxException {
        return PathPattern.toPathPatterns(Arrays.asList(patterns));
    }

    public static List<PathPattern> toPathPatterns(List<String> patterns) throws PathPatternSyntaxException {
        ArrayList<PathPattern> result = new ArrayList<PathPattern>();
        for (String pattern : patterns) {
            result.add(new PathPattern(pattern));
        }
        return result;
    }

    public PathPattern(String pattern) throws PathPatternSyntaxException {
        try {
            this.pattern = PathOffset.sanitize(pattern);
        }
        catch (PathOffset.PathOffsetSyntaxException e) {
            throw new PathPatternSyntaxException("Invalid path pattern: " + pattern, e);
        }
        if (this.pattern.length() == 0) {
            throw new PathPatternSyntaxException("Invalid path pattern: pattern is blank");
        }
    }

    public PathPattern translate(PathOffset offset) {
        PathPattern result;
        Check.nonNull((Object)offset, (String)"offset");
        try {
            result = new PathPattern(offset.toString() + "/" + this.pattern);
        }
        catch (PathPatternSyntaxException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public String toString() {
        return this.pattern;
    }

    static {
        try {
            ALL = new PathPattern("**/*");
        }
        catch (PathPatternSyntaxException impossible) {
            throw new AssertionError();
        }
    }

    public class PathPatternSyntaxException
    extends SyntaxException {
        private static final long serialVersionUID = 1L;

        public PathPatternSyntaxException() {
        }

        public PathPatternSyntaxException(String message) {
            super(message);
        }

        public PathPatternSyntaxException(Throwable cause) {
            super(cause);
        }

        public PathPatternSyntaxException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

