/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.model;

import com.urbancode.ubuild.preflight.model.SyntaxException;

public class LogFile {
    private final String pathOrDash;

    public static LogFile forStandardStream() {
        LogFile result;
        try {
            result = new LogFile("-");
        }
        catch (LogFileSyntaxException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public LogFile(String pathOrDash) throws LogFileSyntaxException {
        if (pathOrDash == null) {
            throw new LogFileSyntaxException("Invalid log file path: path is undefined");
        }
        if ((pathOrDash = pathOrDash.trim()).length() == 0) {
            throw new LogFileSyntaxException("Invalid log file path: path is blank");
        }
        this.pathOrDash = pathOrDash;
    }

    public boolean isFile() {
        return !this.pathOrDash.equals("-");
    }

    public String toString() {
        return this.pathOrDash;
    }

    public static class LogFileSyntaxException
    extends SyntaxException {
        private static final long serialVersionUID = 1L;

        public LogFileSyntaxException() {
        }

        public LogFileSyntaxException(String message) {
            super(message);
        }

        public LogFileSyntaxException(Throwable cause) {
            super(cause);
        }

        public LogFileSyntaxException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

