/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.model;

import com.urbancode.ubuild.preflight.model.SyntaxException;

public class ObjectId {
    private final long id;
    private final String name;

    public ObjectId(String nameOrId) throws ObjectIdSyntaxException {
        String name;
        long id;
        if (nameOrId == null) {
            throw new ObjectIdSyntaxException("Invalid object id: id is undefined");
        }
        if ((nameOrId = nameOrId.trim()).length() == 0) {
            throw new ObjectIdSyntaxException("Invalid object id: id is blank");
        }
        try {
            id = Long.parseLong(nameOrId);
            name = null;
        }
        catch (NumberFormatException e) {
            id = -1L;
            name = nameOrId;
        }
        this.id = id;
        this.name = name;
    }

    public boolean isNumeric() {
        return this.name == null;
    }

    public long getNumericId() {
        if (!this.isNumeric()) {
            throw new IllegalStateException();
        }
        return this.id;
    }

    public String getName() {
        if (this.isNumeric()) {
            throw new IllegalStateException();
        }
        return this.name;
    }

    public String toString() {
        String result = this.isNumeric() ? String.valueOf(this.getNumericId()) : this.getName();
        return result;
    }

    public static class ObjectIdSyntaxException
    extends SyntaxException {
        private static final long serialVersionUID = 1L;

        public ObjectIdSyntaxException() {
        }

        public ObjectIdSyntaxException(String message, Throwable cause) {
            super(message, cause);
        }

        public ObjectIdSyntaxException(String message) {
            super(message);
        }

        public ObjectIdSyntaxException(Throwable cause) {
            super(cause);
        }
    }
}

