/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.fileserver.protocol;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.assertionerrors.AllCasesCoveredError;
import com.urbancode.commons.util.assertionerrors.UnreachableCodeError;
import com.urbancode.commons.util.unix.Unix;
import com.urbancode.ubuild.preflight.fileserver.protocol.FileIOException;
import com.urbancode.ubuild.preflight.fileserver.protocol.FileStream;
import com.urbancode.ubuild.preflight.fileserver.protocol.FileTransferListener;
import com.urbancode.ubuild.preflight.fileserver.protocol.MessageMarshaller;
import com.urbancode.ubuild.preflight.fileserver.protocol.MessageReader;
import com.urbancode.ubuild.preflight.fileserver.protocol.ProtocolCode;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.AckHelloMessage;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.FileMessage;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.HelloMessage;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.Message;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.PathSetMessage;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.RemoteErrorMessage;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata.FileMetadata;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata.ModifiedDateFileMetadata;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata.UnixPermissionsFileMetadata;
import com.urbancode.ubuild.preflight.model.PathSet;
import com.urbancode.ubuild.preflight.model.PreflightFile;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Protocol
implements Closeable {
    private static final Logger log = Logger.getLogger(Protocol.class);
    private static final int version = 1;
    private final Unix unix = new Unix();
    private final DataInputStream in;
    private final DataOutputStream out;
    private final MessageMarshaller marshaller;
    private final Thread readerThread;
    private final BlockingQueue<Message> inputQueue;

    public Protocol(InputStream in, OutputStream out) {
        this.in = IO.data((InputStream)IO.buffer((InputStream)in));
        this.out = IO.data((OutputStream)IO.buffer((OutputStream)out));
        this.marshaller = new MessageMarshaller(this.in, this.out);
        this.inputQueue = new LinkedBlockingQueue<Message>(1024);
        this.readerThread = new Thread(new MessageReader(this.marshaller, this.inputQueue));
        this.readerThread.setName("Protocol-MessageReader");
        this.readerThread.setDaemon(true);
        this.readerThread.start();
    }

    public void doClientHandshake() throws IOException, InterruptedException {
        HelloMessage message = new HelloMessage(1);
        this.sendMessage(message);
        this.getExpectedMessage(ProtocolCode.ACK_HELLO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Client-side handshake complete");
        }
    }

    public void doClientShutdown() throws IOException {
        Message message = new Message(ProtocolCode.CLOSE);
        this.sendMessage(message);
        try {
            this.getExpectedMessage(ProtocolCode.ACK_CLOSE);
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Client-side shutdown complete");
        }
    }

    public void doClientDeliver(File base, FileTransferListener listener) throws IOException, InterruptedException {
        Check.nonNull((Object)base, (String)"base");
        Check.nonNull((Object)listener, (String)"listener");
        Message message = new Message(ProtocolCode.DELIVER);
        this.sendMessage(message);
        PathSetMessage pathSetMessage = (PathSetMessage)this.getExpectedMessage(ProtocolCode.PATH_SET);
        PathSet set = pathSetMessage.getSetPattern();
        List<PreflightFile> files = set.match(base);
        this.sendFiles(listener, base, files);
    }

    @Override
    public void close() throws IOException {
        this.readerThread.interrupt();
        this.in.close();
        this.out.close();
    }

    public void doServerHandshake() throws IOException, InterruptedException {
        this.getExpectedMessage(ProtocolCode.HELLO);
        AckHelloMessage message = new AckHelloMessage(1);
        this.sendMessage(message);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Server-side handshake complete");
        }
    }

    private void sendFiles(FileTransferListener listener, File base, Collection<PreflightFile> artifacts) throws IOException, InterruptedException {
        Check.nonNull((Object)listener, (String)"listener");
        Check.nonNull((Object)base, (String)"base");
        Check.nonNull(artifacts, (String)"artifacts");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending " + artifacts.size() + " files"));
        }
        String remoteError = null;
        for (PreflightFile artifact : artifacts) {
            Message peekedMessage = this.peekMessage();
            if (peekedMessage instanceof RemoteErrorMessage) {
                RemoteErrorMessage error = (RemoteErrorMessage)this.getMessage();
                remoteError = error.getMessage();
                break;
            }
            if (peekedMessage != null) {
                throw new IOException("Protocol error: received " + (Object)((Object)this.getMessage().getCode()));
            }
            this.sendSingleFile(listener, base, artifact);
        }
        Message endFilesMessage = new Message(ProtocolCode.END_FILES);
        this.sendMessage(endFilesMessage);
        this.getExpectedMessage(ProtocolCode.ACK_END_FILES);
        if (remoteError != null) {
            listener.receivedRemoteError(remoteError);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sending files complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSingleFile(FileTransferListener listener, File base, PreflightFile artifact) throws IOException, FileNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Sending file %s (%,d bytes)", artifact.getAbsolutePath(), artifact.length()));
        }
        String path = this.getRelativePath(base, artifact.toFile());
        FileMessage fileMessage = FileMessage.createFromFile(path, artifact);
        FileStream fileStream = fileMessage.getFileStream();
        try {
            long transferSize = fileStream.getSize();
            listener.fileSendStarted(path, transferSize, artifact.toFile());
            try {
                this.sendMessage(fileMessage);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sent file " + artifact.getAbsolutePath()));
                }
                listener.fileSendEnded(path, transferSize, artifact.toFile());
            }
            catch (IOException e) {
                listener.fileSendFailed(path, transferSize, artifact.toFile(), e);
                throw e;
            }
        }
        finally {
            fileStream.close();
        }
    }

    public void retrieveSourceFiles(FileTransferListener listener, File base) throws IOException, InterruptedException {
        Message receiveMessage = new Message(ProtocolCode.RECV);
        this.sendMessage(receiveMessage);
        this.receiveFiles(listener, base);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Request files complete");
        }
    }

    public void runServerLoop(FileTransferListener listener, File sourceFileBase, Collection<PreflightFile> sourceFiles, File deliveryBase, PathSet artifactSetPattern) throws IOException, InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting server loop");
        }
        boolean complete = false;
        block9: while (!complete) {
            Message message = this.getMessage();
            ProtocolCode code = message.getCode();
            switch (code) {
                case LOCAL_ERROR: {
                    throw new UnreachableCodeError();
                }
                case HELLO: {
                    throw new IllegalStateException("Handshake not completed");
                }
                case ACK_CLOSE: 
                case ACK_HELLO: 
                case END_FILES: 
                case ACK_END_FILES: 
                case PATH_SET: 
                case EOF: 
                case FILE: {
                    throw new IOException("Protocol error: received " + (Object)((Object)code));
                }
                case CLOSE: {
                    Message ack = new Message(ProtocolCode.ACK_CLOSE);
                    this.sendMessage(ack);
                    complete = true;
                    if (!log.isDebugEnabled()) continue block9;
                    log.debug((Object)"Server-side shutdown complete");
                    continue block9;
                }
                case DELIVER: {
                    PathSetMessage setMessage = new PathSetMessage(artifactSetPattern);
                    this.sendMessage(setMessage);
                    this.receiveFiles(listener, deliveryBase);
                    continue block9;
                }
                case RECV: {
                    this.sendFiles(listener, sourceFileBase, sourceFiles);
                    continue block9;
                }
                case REMOTE_ERROR: {
                    RemoteErrorMessage error = (RemoteErrorMessage)message;
                    listener.receivedRemoteError(error.getMessage());
                    continue block9;
                }
            }
            throw new AllCasesCoveredError();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Server loop complete");
        }
    }

    private void receiveFiles(FileTransferListener listener, File base) throws IOException, InterruptedException {
        Message endFilesMessage;
        FileIOException fileIOException = null;
        try {
            endFilesMessage = this.receiveFilesNormally(listener, base);
        }
        catch (FileIOException e) {
            fileIOException = e;
            endFilesMessage = this.discardFiles();
        }
        this.checkExpectedMessage(ProtocolCode.END_FILES, endFilesMessage);
        Message ackEndFilesMessage = new Message(ProtocolCode.ACK_END_FILES);
        this.sendMessage(ackEndFilesMessage);
        if (fileIOException != null) {
            throw fileIOException;
        }
    }

    private Message peekMessage() throws IOException, InterruptedException {
        Message result = (Message)this.inputQueue.peek();
        if (result != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Peeked " + (Object)((Object)result.getCode())));
            }
            result.throwIfLocalError();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Peeked <nothing>");
        }
        return result;
    }

    private Message getMessage() throws IOException, InterruptedException {
        Message result = this.inputQueue.take();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received " + (Object)((Object)result.getCode())));
        }
        result.throwIfLocalError();
        return result;
    }

    private void sendMessage(Message message) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sent " + (Object)((Object)message.getCode())));
        }
        this.marshaller.marshal(message);
    }

    private Message getExpectedMessage(ProtocolCode expectedMessageCode) throws IOException, InterruptedException {
        Message result = this.getMessage();
        this.checkExpectedMessage(expectedMessageCode, result);
        return result;
    }

    private void checkExpectedMessage(ProtocolCode expectedMessageCode, Message message) throws IOException {
        if (message.getCode() != expectedMessageCode) {
            throw new IOException(String.format("Expected %s; received %s", new Object[]{expectedMessageCode, message.getCode()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receiveFilesNormally(FileTransferListener listener, File base) throws IOException, InterruptedException {
        Message result;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Receiving files normally");
        }
        while ((result = this.getMessage()).getCode() == ProtocolCode.FILE) {
            FileMessage fileMessage = (FileMessage)result;
            FileStream fileStream = fileMessage.getFileStream();
            try {
                long size = fileStream.getSize();
                String path = fileStream.getPath();
                File destination = new File(base, path);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Receiving " + destination));
                }
                try {
                    listener.fileReceiveStarted(path, size, destination);
                    fileStream.transferTo(destination);
                    for (FileMetadata fileMetadata : fileMessage.getMetadata()) {
                        if (fileMetadata instanceof UnixPermissionsFileMetadata) {
                            UnixPermissionsFileMetadata perms = (UnixPermissionsFileMetadata)fileMetadata;
                            if (this.unix.isUnix()) {
                                try {
                                    this.unix.chmod(destination, (int)perms.getPermissions());
                                }
                                catch (IOException e) {
                                    log.warn((Object)("Failed to restore permissions on " + destination.getAbsolutePath()));
                                    if (!log.isDebugEnabled()) continue;
                                    log.debug((Object)"STACKTRACE", (Throwable)e);
                                }
                                continue;
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Skipping unix perms on non-unix system");
                            continue;
                        }
                        if (fileMetadata instanceof ModifiedDateFileMetadata) {
                            ModifiedDateFileMetadata date = (ModifiedDateFileMetadata)fileMetadata;
                            destination.setLastModified(date.getModifiedDate());
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"Skipping unknown metadata item");
                    }
                    listener.fileReceiveEnded(path, size, destination);
                }
                catch (FileIOException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"File IO error; discarding remainder of file");
                    }
                    RemoteErrorMessage remoteErrorMessage = new RemoteErrorMessage(e.getMessage());
                    this.sendMessage(remoteErrorMessage);
                    fileStream.discard();
                    listener.fileReceiveFailed(path, size, destination, e.getCause());
                }
            }
            finally {
                fileStream.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message discardFiles() throws IOException, InterruptedException {
        Message result;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Discarding files");
        }
        while ((result = this.getMessage()).getCode() == ProtocolCode.FILE) {
            FileMessage fileMessage = (FileMessage)result;
            FileStream fileStream = fileMessage.getFileStream();
            try {
                fileStream.discard();
            }
            finally {
                fileStream.close();
            }
        }
        result.throwIfLocalError();
        return result;
    }

    private String getRelativePath(File base, File target) {
        String filePath;
        String basePath = base.getAbsolutePath();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        if (!(filePath = target.getAbsolutePath()).startsWith(basePath)) {
            throw new IllegalArgumentException(String.format("The file '%s' does not begin with the base directory '%s'.", filePath, basePath));
        }
        return filePath.substring(basePath.length());
    }
}

