/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.fileserver.protocol.messages;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.CollectionUtil;
import com.urbancode.ubuild.preflight.fileserver.protocol.FileStream;
import com.urbancode.ubuild.preflight.fileserver.protocol.ProtocolCode;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.LatchedInputStream;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.Message;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata.FileMetadata;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata.ModifiedDateFileMetadata;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata.UnixPermissionsFileMetadata;
import com.urbancode.ubuild.preflight.model.PreflightFile;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMessage
extends Message {
    private static final Logger log = Logger.getLogger(FileMessage.class);
    private final LatchedInputStream latchedStream;
    private final FileStream fileStream;
    private final List<? extends FileMetadata> metadata;

    public static FileMessage createFromFile(String path, PreflightFile file) throws FileNotFoundException {
        long size = file.length();
        FileInputStream stream = new FileInputStream(file.toFile());
        ModifiedDateFileMetadata date = new ModifiedDateFileMetadata(file.getLastModifiedDate());
        UnixPermissionsFileMetadata perms = new UnixPermissionsFileMetadata(file.getUnixPermissions());
        return new FileMessage(path, size, stream, Arrays.asList(date, perms));
    }

    public FileMessage(String path, long size, InputStream stream, List<? extends FileMetadata> metadata) {
        super(ProtocolCode.FILE);
        metadata = CollectionUtil.nullableCopyList(metadata);
        Check.nonNull((Object)metadata, (String)"metadata");
        Check.nonNull((Object)stream, (String)"stream");
        this.latchedStream = new LatchedInputStream(stream);
        this.fileStream = new FileStream(path, size, this.latchedStream);
        this.metadata = Collections.unmodifiableList(metadata);
    }

    public FileStream getFileStream() {
        return this.fileStream;
    }

    public String getPath() {
        return this.fileStream.getPath();
    }

    public long getSize() {
        return this.fileStream.getSize();
    }

    public List<? extends FileMetadata> getMetadata() {
        return this.metadata;
    }

    @Override
    public void awaitConsumption() throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Waiting for close");
        }
        this.latchedStream.awaitClose();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Close signalled");
        }
    }
}

