/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.plugin;

import com.urbancode.ubuild.preflight.plugin.TransferArtifactsStep;
import com.urbancode.ubuild.preflight.plugin.TransferSourceStep;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Main {
    private static final Logger log = Logger.getLogger(Main.class);
    private final String[] args;

    public static void main(String[] args) {
        System.exit(new Main(args).execute());
    }

    public Main(String[] args) {
        this.args = args;
    }

    public int execute() {
        int result;
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.DEBUG);
        try {
            String stepName = this.args[0];
            String[] remainingArgs = this.subarray(this.args, 1);
            if ("source".equals(stepName)) {
                TransferSourceStep step = new TransferSourceStep(remainingArgs);
                result = step.execute();
            } else if ("artifacts".equals(stepName)) {
                TransferArtifactsStep step = new TransferArtifactsStep(remainingArgs);
                result = step.execute();
            } else {
                log.error("Invalid step name: " + stepName);
                result = 1;
            }
        }
        catch (Exception e) {
            log.fatal("Exception: " + e, e);
            result = 1;
        }
        return result;
    }

    private String[] subarray(String[] array, int offset) {
        String[] result = new String[array.length - offset];
        System.arraycopy(array, offset, result, 0, result.length);
        return result;
    }
}

