/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.crypto;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.ObjectUtil;
import com.urbancode.commons.util.crypto.AlgRegistry;
import com.urbancode.commons.util.crypto.algs.CryptStringAlgorithm;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class CryptStringUtil {
    private static final String OPEN_BRACKET = "{";
    private static final String CLOSE_BRACKET = "}";
    private static final AlgRegistry REGISTRY = new AlgRegistry();
    private static CryptStringUtil instance = null;
    private CryptStringAlgorithm defaultCryptAlg = REGISTRY.getDefaultCrypt();
    private CryptStringAlgorithm defaultHashAlg = REGISTRY.getDefaultHash();

    @Deprecated
    public static CryptStringUtil getInstance() {
        return CryptStringUtil.getDefaultInstance();
    }

    public static synchronized CryptStringUtil getDefaultInstance() {
        if (instance == null) {
            instance = new CryptStringUtil();
        }
        return instance;
    }

    public static void registerCryptStringAlgorithm(CryptStringAlgorithm alg) {
        REGISTRY.addCryptStringAlgorithm(alg);
    }

    public static Set<String> getRegistredAlogrithmPrefixes() {
        return REGISTRY.getAlogrithmPrefixes();
    }

    public static Set<CryptStringAlgorithm> getRegistredAlogrithms() {
        return REGISTRY.getAlogrithms();
    }

    protected static CryptStringAlgorithm lookupAlg(String algPrefix) {
        return REGISTRY.getAlg(algPrefix);
    }

    public static String encrypt(String value) throws GeneralSecurityException, IOException {
        return CryptStringUtil.getDefaultInstance().getEncryptedValue(value);
    }

    public static String hash(String value) throws GeneralSecurityException, IOException {
        return CryptStringUtil.getDefaultInstance().getHashedValue(value);
    }

    public static String decrypt(String cryptValue) throws GeneralSecurityException {
        return CryptStringUtil.getDefaultInstance().getDecryptedValue(cryptValue);
    }

    public static boolean validate(String value, String encoded) throws GeneralSecurityException {
        return CryptStringUtil.getDefaultInstance().validate0(value, encoded);
    }

    public static boolean isEncrypted(String value) throws GeneralSecurityException {
        return !CryptStringUtil.getDefaultInstance().isPlainText(value);
    }

    public void setDefaultCryptAlg(CryptStringAlgorithm defaultCryptAlg) {
        if (!defaultCryptAlg.isDecodeSupported()) {
            throw new IllegalArgumentException("Default Encryption algorithm must support decrypting: " + defaultCryptAlg);
        }
        this.defaultCryptAlg = defaultCryptAlg;
    }

    public CryptStringAlgorithm getDefaultCryptAlg() {
        return this.defaultCryptAlg;
    }

    public void setDefaultHashAlg(CryptStringAlgorithm defaultHashAlg) {
        this.defaultHashAlg = defaultHashAlg;
    }

    public CryptStringAlgorithm getDefaultHashAlg() {
        return this.defaultHashAlg;
    }

    public String getEncryptedValue(String value) throws GeneralSecurityException, IOException {
        String result = this.getEncodedValue(this.defaultCryptAlg, value);
        return result;
    }

    public String getDecryptedValue(String cryptValue) throws GeneralSecurityException {
        String value = null;
        for (int count = 0; !ObjectUtil.isEqual(value, cryptValue) && count < 100; ++count) {
            value = cryptValue;
            cryptValue = this.decryptValueOnce(cryptValue);
        }
        return value;
    }

    public String getHashedValue(String value) throws GeneralSecurityException, IOException {
        String result = this.getEncodedValue(this.defaultHashAlg, value);
        return result;
    }

    public boolean isValid(String plainText, String token) throws GeneralSecurityException {
        return this.validate0(plainText, token);
    }

    public boolean isPlainText(String token) throws GeneralSecurityException {
        return this.getAlgorithmForToken(token) == null;
    }

    protected CryptStringAlgorithm getAlgorithmForToken(String token) throws GeneralSecurityException {
        if (token == null || !token.endsWith(CLOSE_BRACKET)) {
            return null;
        }
        int bodyStart = token.indexOf(OPEN_BRACKET);
        if (bodyStart == -1) {
            return null;
        }
        String algPrefix = token.substring(0, bodyStart);
        CryptStringAlgorithm alg = CryptStringUtil.lookupAlg(algPrefix);
        return alg;
    }

    protected String getEncodedValue(CryptStringAlgorithm alg, String value) throws GeneralSecurityException, IOException {
        if (!alg.isSupported()) {
            throw new UnsupportedOperationException("Unsupported algorithm " + alg.getAlgPrefix());
        }
        String result = alg.getAlgPrefix() + OPEN_BRACKET + alg.encode(value) + CLOSE_BRACKET;
        return result;
    }

    private String decryptValueOnce(String cryptValue) throws GeneralSecurityException {
        String result;
        if (cryptValue != null && cryptValue.endsWith(CLOSE_BRACKET)) {
            int bodyStart = cryptValue.indexOf(OPEN_BRACKET);
            if (bodyStart != -1 && cryptValue.endsWith(CLOSE_BRACKET)) {
                String algPrefix = cryptValue.substring(0, bodyStart);
                String body = cryptValue.substring(bodyStart + 1, cryptValue.length() - 1);
                CryptStringAlgorithm alg = CryptStringUtil.lookupAlg(algPrefix);
                if (alg != null) {
                    if (!alg.isSupported()) {
                        throw new UnsupportedOperationException("Found unsupported algorithm " + algPrefix);
                    }
                    result = alg.decode(body);
                } else {
                    result = cryptValue;
                }
            } else {
                result = cryptValue;
            }
        } else {
            result = cryptValue;
        }
        return result;
    }

    protected boolean validate0(String value, String encoded) throws GeneralSecurityException {
        boolean result;
        if (encoded != null && encoded.endsWith(CLOSE_BRACKET)) {
            int bodyStart = encoded.indexOf(OPEN_BRACKET);
            if (bodyStart != -1 && encoded.endsWith(CLOSE_BRACKET)) {
                String algPrefix = encoded.substring(0, bodyStart);
                String body = encoded.substring(bodyStart + 1, encoded.length() - 1);
                CryptStringAlgorithm alg = CryptStringUtil.lookupAlg(algPrefix);
                if (alg != null) {
                    if (!alg.isSupported()) {
                        throw new UnsupportedOperationException("Found unsupported algorithm " + algPrefix);
                    }
                    if (alg.isDecodeSupported()) {
                        String decoded = this.getDecryptedValue(encoded);
                        result = this.validate0(value, decoded);
                    } else {
                        result = alg.validate(value, body);
                    }
                } else {
                    result = ObjectUtil.isEqual(value, encoded);
                }
            } else {
                result = ObjectUtil.isEqual(value, encoded);
            }
        } else {
            result = ObjectUtil.isEqual(value, encoded);
        }
        return result;
    }

    @Deprecated
    public String encryptPBE(String value) throws GeneralSecurityException, IOException {
        String result = this.getEncodedValue(AlgRegistry.PBE_ALG, value);
        return result;
    }

    @Deprecated
    public String decryptPBE(String cryptValue) throws GeneralSecurityException {
        String result;
        String pbeOpenBracket = AlgRegistry.PBE_ALG.getAlgPrefix() + OPEN_BRACKET;
        if (cryptValue != null && cryptValue.startsWith(pbeOpenBracket) && cryptValue.endsWith(CLOSE_BRACKET)) {
            String strippedCrypt = cryptValue.substring(pbeOpenBracket.length(), cryptValue.length() - CLOSE_BRACKET.length());
            result = AlgRegistry.PBE_ALG.decode(strippedCrypt);
        } else {
            result = cryptValue;
        }
        return result;
    }

    @Deprecated
    public String encryptDESede(String value) throws GeneralSecurityException, IOException {
        String result = this.getEncodedValue(AlgRegistry.DES_ALG, value);
        return result;
    }

    @Deprecated
    public String decryptDESede(String cryptToken) throws GeneralSecurityException {
        String result;
        String desOpenBracket = AlgRegistry.DES_ALG.getAlgPrefix() + OPEN_BRACKET;
        if (cryptToken != null && cryptToken.startsWith(desOpenBracket) && cryptToken.endsWith(CLOSE_BRACKET)) {
            String strippedToken = cryptToken.substring(desOpenBracket.length(), cryptToken.length() - CLOSE_BRACKET.length());
            result = AlgRegistry.DES_ALG.decode(strippedToken);
        } else {
            result = cryptToken;
        }
        return result;
    }
}

