/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.fileserver;

import com.urbancode.commons.util.Check;
import com.urbancode.ubuild.preflight.fileserver.protocol.FileTransferListener;
import com.urbancode.ubuild.preflight.fileserver.protocol.Protocol;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.Logger;

public class PreflightFileClient
implements Closeable {
    private static final Logger log = Logger.getLogger(PreflightFileClient.class);
    private final Socket socket;
    private final Protocol protocol;

    public PreflightFileClient(String host, int port) throws IOException, InterruptedException {
        Check.nonNull((Object)host, (String)"host");
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port " + port);
        }
        this.socket = new Socket(host, port);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connection established to " + this.socket.getRemoteSocketAddress()));
        }
        this.protocol = new Protocol(this.socket.getInputStream(), this.socket.getOutputStream());
        this.protocol.doClientHandshake();
    }

    public void sendArtifacts(File base, FileTransferListener listener) throws IOException, InterruptedException {
        this.protocol.doClientDeliver(base, listener);
    }

    public void retrieveSourceFiles(File base, FileTransferListener listener) throws IOException, InterruptedException {
        this.protocol.retrieveSourceFiles(listener, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.protocol.doClientShutdown();
            this.protocol.close();
        }
        finally {
            this.socket.close();
        }
    }
}

