/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.fileserver.protocol;

import com.urbancode.ubuild.preflight.fileserver.protocol.MessageMarshaller;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.LocalErrorMessage;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.Message;
import java.util.concurrent.BlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageReader
implements Runnable {
    private final MessageMarshaller marshaller;
    private final BlockingQueue<Message> queue;

    public MessageReader(MessageMarshaller marshaller, BlockingQueue<Message> queue) {
        this.marshaller = marshaller;
        this.queue = queue;
    }

    @Override
    public void run() {
        try {
            while (true) {
                Message message = this.marshaller.unmarshal();
                this.queue.put(message);
                message.awaitConsumption();
            }
        }
        catch (InterruptedException swallow) {
        }
        catch (Throwable throwable) {
            try {
                LocalErrorMessage message = new LocalErrorMessage(throwable);
                this.queue.put(message);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

