/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json;

import com.urbancode.commons.util.Check;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class JsonBuildStatus {
    private static final Set<String> abnormalTerminationStatuses;
    private final long id;
    private final URI url;
    private final String status;
    private final boolean complete;
    private final URI requestUrl;

    public JsonBuildStatus(long id, URI url, String status, boolean complete, URI requestUrl) {
        Check.nonNull((Object)url, (String)"url");
        Check.nonNull((Object)status, (String)"status");
        Check.nonNull((Object)requestUrl, (String)"requestUrl");
        this.id = id;
        this.url = url;
        this.status = status;
        this.complete = complete;
        this.requestUrl = requestUrl;
    }

    public long getId() {
        return this.id;
    }

    public URI getUrl() {
        return this.url;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public URI getRequestUrl() {
        return this.requestUrl;
    }

    public boolean isAbnormalTermination() {
        return abnormalTerminationStatuses.contains(this.getStatus());
    }

    static {
        TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        set.add("Failed");
        set.add("Error");
        set.add("Aborted");
        abnormalTerminationStatuses = Collections.unmodifiableSet(set);
    }
}

