/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerMarshaller
extends MarshallerBase<Integer> {
    @Override
    JsonElement nonNullMarshal(Integer value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    Integer nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        Integer result;
        if (!element.isJsonPrimitive()) {
            throw new JsonFormatException("element is not an integer");
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (!primitive.isNumber()) {
            throw new JsonFormatException("element is not an integer");
        }
        try {
            result = primitive.getAsInt();
        }
        catch (NumberFormatException e) {
            throw new JsonFormatException("element is not an integer: " + e.getMessage(), e);
        }
        return result;
    }
}

