/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.urbancode.ubuild.preflight.json.JsonArtifactSetLookupRequest;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.ListMarshaller;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;
import com.urbancode.ubuild.preflight.json.marshaller.ObjectIdMarshaller;
import com.urbancode.ubuild.preflight.model.ObjectId;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonArtifactSetLookupRequestMarshaller
extends MarshallerBase<JsonArtifactSetLookupRequest> {
    private static final String PROJECT = "project";
    private static final String WORKFLOW = "workflow";
    private static final String ARTIFACT_SETS = "artifactSets";
    private final ObjectIdMarshaller idMarshaller = new ObjectIdMarshaller();
    private final ListMarshaller<ObjectId> listMarshaller = new ListMarshaller<ObjectId>(this.idMarshaller);

    @Override
    JsonElement nonNullMarshal(JsonArtifactSetLookupRequest value) {
        JsonObject result = new JsonObject();
        result.add(PROJECT, this.idMarshaller.marshal(value.getProject()));
        result.add(WORKFLOW, this.idMarshaller.marshal(value.getWorkflow()));
        result.add(ARTIFACT_SETS, this.listMarshaller.marshal((ObjectId)((Object)value.getArtifactSets())));
        return result;
    }

    @Override
    JsonArtifactSetLookupRequest nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        JsonObject object = this.asJsonObject(element);
        ObjectId project = (ObjectId)this.nonNull(this.idMarshaller.unmarshal(object.get(PROJECT)));
        ObjectId workflow = (ObjectId)this.nonNull(this.idMarshaller.unmarshal(object.get(WORKFLOW)));
        List<ObjectId> artifactSets = this.allNonNull((List)this.listMarshaller.unmarshal(object.get(ARTIFACT_SETS)));
        return new JsonArtifactSetLookupRequest(project, workflow, artifactSets);
    }
}

