/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.urbancode.ubuild.preflight.json.JsonBuildRequest;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.LocalServerHostMarshaller;
import com.urbancode.ubuild.preflight.json.marshaller.LocalServerPortMarshaller;
import com.urbancode.ubuild.preflight.json.marshaller.MapMarshaller;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;
import com.urbancode.ubuild.preflight.json.marshaller.ObjectIdMarshaller;
import com.urbancode.ubuild.preflight.json.marshaller.StringMarshaller;
import com.urbancode.ubuild.preflight.model.LocalServerHost;
import com.urbancode.ubuild.preflight.model.LocalServerPort;
import com.urbancode.ubuild.preflight.model.ObjectId;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonBuildRequestMarshaller
extends MarshallerBase<JsonBuildRequest> {
    private static final String PROJECT = "project";
    private static final String WORKFLOW = "workflow";
    private static final String PROPERTIES = "properties";
    private static final String SERVER_HOST = "serverHost";
    private static final String SERVER_PORT = "serverPort";
    private final ObjectIdMarshaller idMarshaller = new ObjectIdMarshaller();
    private final MapMarshaller<String> propertyMarshaller = new MapMarshaller<String>(new StringMarshaller());
    private final LocalServerHostMarshaller hostMarshaller = new LocalServerHostMarshaller();
    private final LocalServerPortMarshaller portMarshaller = new LocalServerPortMarshaller();

    @Override
    JsonElement nonNullMarshal(JsonBuildRequest value) {
        JsonObject result = new JsonObject();
        result.add(PROJECT, this.idMarshaller.marshal(value.getProject()));
        result.add(WORKFLOW, this.idMarshaller.marshal(value.getWorkflow()));
        result.add(PROPERTIES, this.propertyMarshaller.marshal(value.getProperties()));
        result.add(SERVER_HOST, this.hostMarshaller.marshal(value.getServerHost()));
        result.add(SERVER_PORT, this.portMarshaller.marshal(value.getServerPort()));
        return result;
    }

    @Override
    JsonBuildRequest nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        JsonObject object = this.asJsonObject(element);
        ObjectId project = (ObjectId)this.nonNull(this.idMarshaller.unmarshal(object.get(PROJECT)));
        ObjectId workflow = (ObjectId)this.nonNull(this.idMarshaller.unmarshal(object.get(WORKFLOW)));
        Map<String, String> properties = this.allNonNull((Map)this.propertyMarshaller.unmarshal(object.get(PROPERTIES)));
        LocalServerHost serverHost = (LocalServerHost)this.nonNull(this.hostMarshaller.unmarshal(object.get(SERVER_HOST)));
        LocalServerPort serverPort = (LocalServerPort)this.nonNull(this.portMarshaller.unmarshal(object.get(SERVER_PORT)));
        return new JsonBuildRequest(project, workflow, properties, serverHost, serverPort);
    }
}

