/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonElement;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;
import com.urbancode.ubuild.preflight.json.marshaller.StringMarshaller;
import com.urbancode.ubuild.preflight.model.LocalServerHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalServerHostMarshaller
extends MarshallerBase<LocalServerHost> {
    private final StringMarshaller stringMarshaller = new StringMarshaller();

    @Override
    JsonElement nonNullMarshal(LocalServerHost value) {
        return this.stringMarshaller.marshal(value.toString());
    }

    @Override
    LocalServerHost nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        LocalServerHost result;
        try {
            String host = (String)this.nonNull(this.stringMarshaller.unmarshal(element));
            result = new LocalServerHost(host);
        }
        catch (LocalServerHost.LocalServerHostSyntaxException e) {
            throw new JsonFormatException(e.getMessage(), e);
        }
        return result;
    }
}

