/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonElement;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;
import com.urbancode.ubuild.preflight.json.marshaller.StringMarshaller;
import com.urbancode.ubuild.preflight.model.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIdMarshaller
extends MarshallerBase<ObjectId> {
    private final StringMarshaller stringMarshaller = new StringMarshaller();

    @Override
    JsonElement nonNullMarshal(ObjectId value) {
        return this.stringMarshaller.marshal(value.toString());
    }

    @Override
    ObjectId nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        ObjectId result;
        try {
            String id = (String)this.nonNull(this.stringMarshaller.unmarshal(element));
            result = new ObjectId(id);
        }
        catch (ObjectId.ObjectIdSyntaxException e) {
            throw new JsonFormatException(e.getMessage(), e);
        }
        return result;
    }
}

