/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonElement;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;
import com.urbancode.ubuild.preflight.json.marshaller.StringMarshaller;
import com.urbancode.ubuild.preflight.model.PathOffset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathOffsetMarshaller
extends MarshallerBase<PathOffset> {
    private final StringMarshaller stringMarshaller = new StringMarshaller();

    @Override
    JsonElement nonNullMarshal(PathOffset value) {
        return this.stringMarshaller.marshal(value.toString());
    }

    @Override
    PathOffset nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        PathOffset result;
        try {
            String offset = (String)this.nonNull(this.stringMarshaller.unmarshal(element));
            result = new PathOffset(offset);
        }
        catch (PathOffset.PathOffsetSyntaxException e) {
            throw new JsonFormatException(e.getMessage(), e);
        }
        return result;
    }
}

