/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonElement;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;
import com.urbancode.ubuild.preflight.json.marshaller.StringMarshaller;
import com.urbancode.ubuild.preflight.model.PathPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathPatternMarshaller
extends MarshallerBase<PathPattern> {
    private final StringMarshaller stringMarshaller = new StringMarshaller();

    @Override
    JsonElement nonNullMarshal(PathPattern value) {
        return this.stringMarshaller.marshal(value.toString());
    }

    @Override
    PathPattern nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        PathPattern result;
        try {
            String pattern = (String)this.nonNull(this.stringMarshaller.unmarshal(element));
            result = new PathPattern(pattern);
        }
        catch (PathPattern.PathPatternSyntaxException e) {
            throw new JsonFormatException(e.getMessage(), e);
        }
        return result;
    }
}

