/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.model;

import com.urbancode.ubuild.preflight.model.SyntaxException;
import java.net.InetSocketAddress;

public class LocalServerPort {
    private final int port;

    public static LocalServerPort getDefaultPort() {
        LocalServerPort result;
        try {
            result = new LocalServerPort("7010");
        }
        catch (LocalServerPortSyntaxException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public LocalServerPort(int port) throws LocalServerPortSyntaxException {
        this.port = port;
        this.validatePort();
    }

    public LocalServerPort(String port) throws LocalServerPortSyntaxException {
        try {
            this.port = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new LocalServerPortSyntaxException("Invalid preflight client port: not a number: " + port, e);
        }
        this.validatePort();
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.toInt());
    }

    public String toString() {
        return String.valueOf(this.toInt());
    }

    public int toInt() {
        return this.port;
    }

    private void validatePort() throws LocalServerPortSyntaxException {
        if (this.port < 0 || this.port > 65535) {
            throw new LocalServerPortSyntaxException("Invalid preflight client port: invalid port number: " + this.port);
        }
    }

    public class LocalServerPortSyntaxException
    extends SyntaxException {
        private static final long serialVersionUID = 1L;

        public LocalServerPortSyntaxException() {
        }

        public LocalServerPortSyntaxException(String message, Throwable cause) {
            super(message, cause);
        }

        public LocalServerPortSyntaxException(String message) {
            super(message);
        }

        public LocalServerPortSyntaxException(Throwable cause) {
            super(cause);
        }
    }
}

