/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.model;

import com.urbancode.commons.util.Check;
import java.io.File;

public class PreflightFile {
    public static final int DEFAULT_PERMISSIONS = 420;
    private final File file;
    private final int unixPermissions;

    public PreflightFile(File file, int unixPermissions) {
        Check.nonNull((Object)file, (String)"file");
        this.file = file;
        this.unixPermissions = 0xFFF & unixPermissions;
    }

    public PreflightFile(File file) {
        this(file, 420);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof PreflightFile) {
            PreflightFile rhs = (PreflightFile)obj;
            result = this.toFile().equals(rhs.toFile());
        }
        return result;
    }

    public int hashCode() {
        return this.toFile().hashCode();
    }

    public String toString() {
        return this.toFile().toString();
    }

    public File toFile() {
        return this.file;
    }

    public int getUnixPermissions() {
        return this.unixPermissions;
    }

    public String getName() {
        return this.toFile().getName();
    }

    public String getAbsolutePath() {
        return this.toFile().getAbsolutePath();
    }

    public long getLastModifiedDate() {
        return this.toFile().lastModified();
    }

    public long length() {
        return this.toFile().length();
    }
}

