/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.LongMarshaller;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;
import com.urbancode.ubuild.preflight.json.marshaller.PathSetMarshaller;
import com.urbancode.ubuild.preflight.json.marshaller.StringMarshaller;
import com.urbancode.ubuild.preflight.model.ArtifactSet;
import com.urbancode.ubuild.preflight.model.PathSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactSetMarshaller
extends MarshallerBase<ArtifactSet> {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String PATTERNS = "patterns";
    private final LongMarshaller longMarshaller = new LongMarshaller();
    private final PathSetMarshaller pathSetMarshaller = new PathSetMarshaller();
    private final StringMarshaller stringMarshaller = new StringMarshaller();

    @Override
    JsonElement nonNullMarshal(ArtifactSet value) {
        JsonObject result = new JsonObject();
        result.add(ID, this.longMarshaller.marshal(value.getId()));
        result.add(NAME, this.stringMarshaller.marshal(value.getName()));
        result.add(PATTERNS, this.pathSetMarshaller.marshal(value.getPatterns()));
        return result;
    }

    @Override
    ArtifactSet nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        JsonObject object = this.asJsonObject(element);
        Long id = (Long)this.nonNull(this.longMarshaller.unmarshal(object.get(ID)));
        String name = (String)this.nonNull(this.stringMarshaller.unmarshal(object.get(NAME)));
        PathSet patterns = (PathSet)this.nonNull(this.pathSetMarshaller.unmarshal(object.get(PATTERNS)));
        return new ArtifactSet(id, name, patterns);
    }
}

