/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanMarshaller
extends MarshallerBase<Boolean> {
    @Override
    JsonElement nonNullMarshal(Boolean value) {
        return new JsonPrimitive(value);
    }

    @Override
    Boolean nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        if (!element.isJsonPrimitive()) {
            throw new JsonFormatException("element is not boolean");
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (!primitive.isBoolean()) {
            throw new JsonFormatException("element is not boolean");
        }
        return primitive.getAsBoolean();
    }
}

