/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.model;

import com.urbancode.commons.util.Check;
import com.urbancode.ubuild.preflight.model.SyntaxException;

public class Property {
    private final String name;
    private final String value;

    public Property(String nameAndValue) throws PropertySyntaxException {
        if (nameAndValue == null) {
            throw new PropertySyntaxException("Invalid property: property is undefined");
        }
        int equalIndex = nameAndValue.indexOf(61);
        if (equalIndex == -1) {
            throw new PropertySyntaxException("Invalid property: property has no value: " + nameAndValue);
        }
        if (equalIndex == 0) {
            throw new PropertySyntaxException("Invalid property: name is blank: " + nameAndValue);
        }
        if (equalIndex == nameAndValue.length() - 1) {
            throw new PropertySyntaxException("Invalid property: value is blank: " + nameAndValue);
        }
        String name = nameAndValue.substring(0, equalIndex).trim();
        String value = nameAndValue.substring(equalIndex + 1).trim();
        if (name.length() == 0) {
            throw new PropertySyntaxException("Invalid property: name is blank: " + nameAndValue);
        }
        if (value.length() == 0) {
            throw new PropertySyntaxException("Invalid property: value is blank: " + nameAndValue);
        }
        this.name = name;
        this.value = value;
    }

    public Property(String name, String value) {
        Check.nonBlank((CharSequence)name, (String)"name");
        Check.nonBlank((CharSequence)value, (String)"value");
        this.name = name.trim();
        this.value = value.trim();
    }

    public String toString() {
        return this.getName() + "=" + this.getValue();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static class PropertySyntaxException
    extends SyntaxException {
        private static final long serialVersionUID = 1L;

        public PropertySyntaxException() {
        }

        public PropertySyntaxException(String message) {
            super(message);
        }

        public PropertySyntaxException(Throwable cause) {
            super(cause);
        }

        public PropertySyntaxException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

