/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.fileserver;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.concurrent.NamedThreadFactory;
import com.urbancode.ubuild.preflight.fileserver.protocol.FileTransferListener;
import com.urbancode.ubuild.preflight.fileserver.protocol.Protocol;
import com.urbancode.ubuild.preflight.model.LocalServerPort;
import com.urbancode.ubuild.preflight.model.PathSet;
import com.urbancode.ubuild.preflight.model.PreflightFile;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreflightFileServer {
    private static final Logger log = Logger.getLogger(PreflightFileServer.class);
    private final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("Preflight-Server-Worker", NamedThreadFactory.ThreadMode.DAEMON));
    private final File sourceFileBase;
    private final Collection<PreflightFile> sourceFiles;
    private final File deliveryBase;
    private final PathSet artifactPathSet;
    private final FileTransferListener fileTransferListener;
    private final Thread accepterThread;
    private volatile boolean stopped;
    private LocalServerPort port;

    public PreflightFileServer(SocketAddress address, File sourceFileBase, Collection<PreflightFile> sourceFiles, File deliveryBase, PathSet artifactPathSet, FileTransferListener fileTransferListener) throws IOException {
        Check.nonNull((Object)address, (String)"address");
        Check.nonNull((Object)deliveryBase, (String)"base");
        Check.nonNull(sourceFiles, (String)"files");
        Check.nonNull((Object)artifactPathSet, (String)"artifactPathSet");
        Check.nonNull((Object)fileTransferListener, (String)"fileTransferListener");
        this.sourceFileBase = sourceFileBase;
        this.sourceFiles = sourceFiles;
        this.artifactPathSet = artifactPathSet;
        this.deliveryBase = deliveryBase;
        this.fileTransferListener = fileTransferListener;
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.bind(address);
        try {
            this.port = new LocalServerPort(serverSocket.getLocalPort());
        }
        catch (LocalServerPort.LocalServerPortSyntaxException e) {
            throw new RuntimeException(e);
        }
        this.accepterThread = new Accepter(serverSocket);
    }

    public synchronized void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Server starting");
        }
        if (this.stopped) {
            throw new IllegalStateException();
        }
        this.accepterThread.start();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Server started");
        }
    }

    public synchronized void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Server stopping");
        }
        this.stopped = true;
        this.accepterThread.interrupt();
        List<Runnable> workers = this.executor.shutdownNow();
        for (Runnable worker : workers) {
            ((Worker)worker).closeSocket();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Server stopped");
        }
    }

    public LocalServerPort getPort() {
        return this.port;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private void handleWorkerException(Throwable cause) {
        log.error((Object)"Exception in worker", cause);
    }

    private void handleAccepterException(Throwable cause) {
        log.error((Object)"Exception in accepter", cause);
    }

    private class Worker
    implements Runnable {
        final Socket socket;

        Worker(Socket socket) {
            Check.nonNull((Object)socket, (String)"socket");
            this.socket = socket;
        }

        public void closeSocket() {
            IO.closeNoThrow((Socket)this.socket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Worker started");
                }
                try {
                    Protocol protocol = new Protocol(this.socket.getInputStream(), this.socket.getOutputStream());
                    protocol.doServerHandshake();
                    protocol.runServerLoop(PreflightFileServer.this.fileTransferListener, PreflightFileServer.this.sourceFileBase, PreflightFileServer.this.sourceFiles, PreflightFileServer.this.deliveryBase, PreflightFileServer.this.artifactPathSet);
                }
                catch (IOException e) {
                    if (!Thread.interrupted()) {
                        throw e;
                    }
                }
                finally {
                    this.socket.close();
                }
            }
            catch (InterruptedException swallow) {
            }
            catch (InterruptedIOException swallow) {
            }
            catch (Throwable t) {
                PreflightFileServer.this.handleWorkerException(t);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Worker finished");
            }
        }
    }

    private class Accepter
    extends Thread {
        final ServerSocket serverSocket;
        private volatile boolean interrupted;

        Accepter(ServerSocket serverSocket) {
            Check.nonNull((Object)serverSocket, (String)"serverSocket");
            this.serverSocket = serverSocket;
            this.setName("Preflight-Server-Accepter");
        }

        public void interrupt() {
            super.interrupt();
            this.interrupted = true;
            IO.closeNoThrow((ServerSocket)this.serverSocket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: {
                try {
                    try {
                        while (!Thread.currentThread().isInterrupted()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Waiting for connection");
                            }
                            Socket socket = this.serverSocket.accept();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Connection established from " + socket.getRemoteSocketAddress()));
                            }
                            Worker worker = new Worker(socket);
                            PreflightFileServer.this.executor.execute(worker);
                        }
                    }
                    finally {
                        this.serverSocket.close();
                    }
                }
                catch (InterruptedIOException swallow) {
                }
                catch (Throwable t) {
                    if (this.interrupted) break block9;
                    PreflightFileServer.this.handleAccepterException(t);
                }
            }
        }
    }
}

