/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json;

import com.urbancode.commons.util.Check;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class JsonRequestStatus {
    private static final Set<String> noBuildRequestStatuses;
    private final long id;
    private final URI url;
    private final String status;
    private final boolean complete;
    private final URI buildLifeUrl;
    private final Integer waitingDependencyCount;

    public JsonRequestStatus(long id, URI url, String status, boolean complete, URI buildLifeUrl, Integer waitingDependencyCount) {
        Check.nonNull((Object)url, (String)"url");
        Check.nonNull((Object)status, (String)"status");
        this.id = id;
        this.url = url;
        this.status = status;
        this.complete = complete;
        this.buildLifeUrl = buildLifeUrl;
        this.waitingDependencyCount = waitingDependencyCount;
    }

    public long getId() {
        return this.id;
    }

    public URI getUrl() {
        return this.url;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public Integer getWaitingDependencyCount() {
        return this.waitingDependencyCount;
    }

    public URI getBuildLifeUrl() {
        return this.buildLifeUrl;
    }

    public boolean isAbnormalTermination() {
        return this.getStatus().equalsIgnoreCase("Failed");
    }

    public boolean isBuildProduced() {
        return !noBuildRequestStatuses.contains(this.getStatus());
    }

    static {
        TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        set.add("Failed");
        set.add("New Build Life Not Needed");
        noBuildRequestStatuses = Collections.unmodifiableSet(set);
    }
}

