/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.model;

import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.CollectionUtil;
import com.urbancode.commons.util.unix.UnixPermissions;
import com.urbancode.ubuild.preflight.model.PathOffset;
import com.urbancode.ubuild.preflight.model.PathPattern;
import com.urbancode.ubuild.preflight.model.PreflightFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathSet {
    private static final Logger log = Logger.getLogger(PathSet.class);
    private final PathOffset offset;
    private final List<PathPattern> includes;
    private final List<PathPattern> excludes;

    public PathSet(PathOffset offset, List<PathPattern> includes, List<PathPattern> excludes) {
        includes = CollectionUtil.nullableCopyList(includes);
        excludes = CollectionUtil.nullableCopyList(excludes);
        Check.nonNull((Object)offset, (String)"offset");
        Check.allNonNull((Collection)includes, (String)"includes");
        Check.allNonNull((Collection)excludes, (String)"excludes");
        this.offset = offset;
        this.includes = Collections.unmodifiableList(includes);
        this.excludes = Collections.unmodifiableList(excludes);
        if (log.isDebugEnabled()) {
            log.debug((Object)("offset=" + offset));
            log.debug((Object)("includes=" + includes));
            log.debug((Object)("excludes=" + excludes));
        }
    }

    public PathOffset getOffset() {
        return this.offset;
    }

    public List<PathPattern> getIncludes() {
        return this.includes;
    }

    public List<PathPattern> getExcludes() {
        return this.excludes;
    }

    public List<PreflightFile> match(File base) throws IOException {
        ArrayList<PreflightFile> result = new ArrayList<PreflightFile>();
        File translatedBase = this.getOffset().translate(base);
        if (log.isDebugEnabled()) {
            log.debug((Object)("base=" + base));
            log.debug((Object)("offset=" + this.getOffset()));
            log.debug((Object)("translatedBase=" + translatedBase));
        }
        FileListerBuilder builder = new FileListerBuilder(translatedBase);
        builder.directories(FileListerBuilder.Directories.EXCLUDE);
        builder.permissions(FileListerBuilder.Permissions.BEST_EFFORT);
        builder.symlinks(FileListerBuilder.Symlinks.FOLLOW);
        if (this.getIncludes().isEmpty()) {
            String include = PathPattern.ALL.toString();
            builder.include(new String[]{include});
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added include " + include + " to match set"));
            }
        }
        for (PathPattern pattern : this.getIncludes()) {
            String include = pattern.toString();
            builder.include(new String[]{include});
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Added include " + include + " to match set"));
        }
        for (PathPattern pattern : this.getExcludes()) {
            String exclude = pattern.toString();
            builder.exclude(new String[]{exclude});
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Added exclude " + exclude + " to match set"));
        }
        for (TypedFile tf : builder.build().list()) {
            File file = tf.translate(translatedBase);
            UnixPermissions perms = (UnixPermissions)tf.permissionView(UnixPermissions.class);
            if (perms != null) {
                result.add(new PreflightFile(file, perms.getMode()));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Created PreflightFile with permissions " + perms.getOctalMode()));
                continue;
            }
            result.add(new PreflightFile(file));
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)"Created PreflightFile with default permissions");
        }
        return Collections.unmodifiableList(result);
    }
}

