/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.CollectionUtil;
import com.urbancode.ubuild.preflight.model.LocalServerHost;
import com.urbancode.ubuild.preflight.model.LocalServerPort;
import com.urbancode.ubuild.preflight.model.ObjectId;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonBuildRequest {
    private final ObjectId project;
    private final ObjectId workflow;
    private final Map<String, String> properties;
    private final LocalServerHost serverHost;
    private final LocalServerPort serverPort;

    public JsonBuildRequest(ObjectId project, ObjectId workflow, Map<String, String> properties, LocalServerHost serverHost, LocalServerPort serverPort) {
        properties = CollectionUtil.nullableCopyMap(properties);
        Check.nonNull((Object)project, (String)"project");
        Check.nonNull((Object)workflow, (String)"workflow");
        Check.allNonNull((Map)properties, (String)"properties");
        Check.nonNull((Object)serverHost, (String)"serverHost");
        Check.nonNull((Object)serverPort, (String)"serverPort");
        this.project = project;
        this.workflow = workflow;
        this.properties = Collections.unmodifiableMap(properties);
        this.serverHost = serverHost;
        this.serverPort = serverPort;
    }

    public ObjectId getProject() {
        return this.project;
    }

    public ObjectId getWorkflow() {
        return this.workflow;
    }

    public LocalServerHost getServerHost() {
        return this.serverHost;
    }

    public LocalServerPort getServerPort() {
        return this.serverPort;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

