/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.Marshaller;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MarshallerBase<T>
implements Marshaller<T> {
    MarshallerBase() {
    }

    protected boolean isNull(JsonElement element) {
        return element == null || element.isJsonNull();
    }

    protected <V> V nullable(V value) {
        return value;
    }

    protected <V> List<V> allNullable(List<V> value) {
        return value;
    }

    protected <V> V nonNull(V value) throws JsonFormatException {
        if (value == null) {
            throw new JsonFormatException("value is null");
        }
        return value;
    }

    protected <V> List<V> allNonNull(List<V> value) throws JsonFormatException {
        if (value == null) {
            throw new JsonFormatException("value is null");
        }
        for (V v : value) {
            if (v != null) continue;
            throw new JsonFormatException("value element is null");
        }
        return value;
    }

    protected <V> Map<String, V> allNonNull(Map<String, V> value) throws JsonFormatException {
        if (value == null) {
            throw new JsonFormatException("value is null");
        }
        for (V v : value.values()) {
            if (v != null) continue;
            throw new JsonFormatException("value element is null");
        }
        return value;
    }

    protected JsonObject asJsonObject(JsonElement element) throws JsonFormatException {
        if (element == null) {
            throw new JsonFormatException("element is not an object");
        }
        if (!element.isJsonObject()) {
            throw new JsonFormatException("element is not an object");
        }
        return element.getAsJsonObject();
    }

    protected JsonArray asJsonArray(JsonElement element) throws JsonFormatException {
        if (element == null) {
            throw new JsonFormatException("element is not an object");
        }
        if (!element.isJsonArray()) {
            throw new JsonFormatException("element is not an object");
        }
        return element.getAsJsonArray();
    }

    @Override
    public JsonElement marshal(T value) {
        Object result = value != null ? this.nonNullMarshal(value) : new JsonNull();
        return result;
    }

    @Override
    public T unmarshal(JsonElement element) throws JsonFormatException {
        T result = null;
        if (!this.isNull(element)) {
            result = this.nonNullUnmarshal(element);
        }
        return result;
    }

    abstract JsonElement nonNullMarshal(T var1);

    abstract T nonNullUnmarshal(JsonElement var1) throws JsonFormatException;
}

