/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.ListMarshaller;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;
import com.urbancode.ubuild.preflight.json.marshaller.PathOffsetMarshaller;
import com.urbancode.ubuild.preflight.json.marshaller.PathPatternMarshaller;
import com.urbancode.ubuild.preflight.model.PathOffset;
import com.urbancode.ubuild.preflight.model.PathPattern;
import com.urbancode.ubuild.preflight.model.PathSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathSetMarshaller
extends MarshallerBase<PathSet> {
    private static final String OFFSET = "offset";
    private static final String INCLUDES = "includes";
    private static final String EXCLUDES = "excludes";
    private final PathOffsetMarshaller offsetMarshaller = new PathOffsetMarshaller();
    private final ListMarshaller<PathPattern> patternMarshaller = new ListMarshaller<PathPattern>(new PathPatternMarshaller());

    @Override
    JsonElement nonNullMarshal(PathSet value) {
        JsonObject result = new JsonObject();
        result.add(OFFSET, this.offsetMarshaller.marshal(value.getOffset()));
        result.add(INCLUDES, this.patternMarshaller.marshal((PathPattern)((Object)value.getIncludes())));
        result.add(EXCLUDES, this.patternMarshaller.marshal((PathPattern)((Object)value.getExcludes())));
        return result;
    }

    @Override
    PathSet nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        JsonObject object = this.asJsonObject(element);
        PathOffset offset = (PathOffset)this.nonNull(this.offsetMarshaller.unmarshal(object.get(OFFSET)));
        List<PathPattern> includes = this.allNonNull((List)this.patternMarshaller.unmarshal(object.get(INCLUDES)));
        List<PathPattern> excludes = this.allNonNull((List)this.patternMarshaller.unmarshal(object.get(EXCLUDES)));
        return new PathSet(offset, includes, excludes);
    }
}

