/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.model;

import com.urbancode.commons.util.Check;
import com.urbancode.ubuild.preflight.model.SyntaxException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class LocalServerHost {
    private final String addressString;
    private final InetAddress address;

    public static void main(String[] args) throws Exception {
        new LocalServerHost("foo");
    }

    public LocalServerHost(String address) throws LocalServerHostSyntaxException {
        Check.nonNull((Object)address, (String)"address");
        address = address.trim();
        try {
            this.addressString = address;
            this.address = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new LocalServerHostSyntaxException("Invalid preflight client host: unknown host: " + address, e);
        }
        if (this.address.isAnyLocalAddress()) {
            throw new LocalServerHostSyntaxException("Invalid preflight client host: " + address + " is a wildcard address");
        }
    }

    public String toString() {
        return this.addressString;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public static class LocalServerHostSyntaxException
    extends SyntaxException {
        private static final long serialVersionUID = 1L;

        public LocalServerHostSyntaxException() {
        }

        public LocalServerHostSyntaxException(String message, Throwable cause) {
            super(message, cause);
        }

        public LocalServerHostSyntaxException(String message) {
            super(message);
        }

        public LocalServerHostSyntaxException(Throwable cause) {
            super(cause);
        }
    }
}

