/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.fileserver.protocol;

import com.urbancode.commons.util.IO;
import com.urbancode.ubuild.preflight.fileserver.protocol.FileIOException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class FileStream
implements Closeable {
    private static final Logger log = Logger.getLogger(FileStream.class);
    private final String path;
    private final long size;
    private final InputStream stream;

    public static FileStream createFromFile(String path, File file) throws FileNotFoundException {
        long size = file.length();
        return new FileStream(path, size, new FileInputStream(file));
    }

    public FileStream(String path, long size, InputStream stream) {
        this.path = path;
        this.size = size;
        this.stream = stream;
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void close() throws IOException {
        this.getStream().close();
        if (log.isDebugEnabled()) {
            log.trace((Object)("Stream " + this.getPath() + " closed"));
        }
    }

    public void discard() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Discarding stream " + this.getPath()));
        }
        this.transferTo(IO.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferTo(File file) throws IOException {
        FileOutputStream out;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Writing file to " + file.getCanonicalPath()));
        }
        try {
            IO.mkdirs((File)file.getParentFile());
            out = new FileOutputStream(file);
        }
        catch (IOException e) {
            throw new FileIOException(e);
        }
        boolean exceptionInProgress = true;
        try {
            int read;
            byte[] buffer = new byte[8192];
            long count = this.getSize();
            int length = (int)Math.min(count, (long)buffer.length);
            while (count > 0L && (read = this.getStream().read(buffer, 0, length)) != -1) {
                try {
                    out.write(buffer, 0, read);
                }
                catch (IOException e) {
                    throw new FileIOException(e);
                }
                length = (int)Math.min(count -= (long)read, (long)buffer.length);
            }
            if (count != 0L) {
                long expected = this.getSize();
                long received = expected - count;
                throw new IOException(String.format("Stream truncated: expected %d bytes, received %d", expected, received));
            }
            exceptionInProgress = false;
        }
        finally {
            IO.closeSafely((Closeable)out, (boolean)exceptionInProgress);
        }
    }

    public void transferTo(OutputStream out) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Writing file " + this.getPath() + " to stream"));
        }
        long expected = this.getSize();
        long remaining = IO.copy((InputStream)this.getStream(), (OutputStream)out, (long)expected);
        if (remaining != 0L) {
            long received = expected - remaining;
            throw new IOException(String.format("Stream truncated: expected %d bytes, received %d", expected, received));
        }
    }
}

