/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.CollectionUtil;
import com.urbancode.ubuild.preflight.model.ObjectId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonArtifactSetLookupRequest {
    private final ObjectId project;
    private final ObjectId workflow;
    private final List<ObjectId> artifactSets;

    public JsonArtifactSetLookupRequest(ObjectId project, ObjectId workflow, List<ObjectId> artifactSets) {
        artifactSets = CollectionUtil.nullableCopyList(artifactSets);
        Check.nonNull((Object)project, (String)"project");
        Check.nonNull((Object)workflow, (String)"workflow");
        Check.allNonNull((Collection)artifactSets, (String)"artifactSets");
        this.project = project;
        this.workflow = workflow;
        this.artifactSets = Collections.unmodifiableList(artifactSets);
    }

    public ObjectId getProject() {
        return this.project;
    }

    public ObjectId getWorkflow() {
        return this.workflow;
    }

    public List<ObjectId> getArtifactSets() {
        return this.artifactSets;
    }
}

