/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.urbancode.ubuild.preflight.json.JsonBuildStatus;
import com.urbancode.ubuild.preflight.json.marshaller.BooleanMarshaller;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.LongMarshaller;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;
import com.urbancode.ubuild.preflight.json.marshaller.StringMarshaller;
import com.urbancode.ubuild.preflight.json.marshaller.UriMarshaller;
import java.net.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonBuildStatusMarshaller
extends MarshallerBase<JsonBuildStatus> {
    private static final String ID = "id";
    private static final String URL = "url";
    private static final String STATUS = "status";
    private static final String COMPLETE = "complete";
    private static final String REQUEST_URL = "requestUrl";
    private final LongMarshaller longMarshaller = new LongMarshaller();
    private final UriMarshaller uriMarshaller = new UriMarshaller();
    private final StringMarshaller stringMarshaller = new StringMarshaller();
    private final BooleanMarshaller booleanMarshaller = new BooleanMarshaller();

    @Override
    JsonElement nonNullMarshal(JsonBuildStatus value) {
        JsonObject result = new JsonObject();
        result.add(ID, this.longMarshaller.marshal(value.getId()));
        result.add(URL, this.uriMarshaller.marshal(value.getUrl()));
        result.add(STATUS, this.stringMarshaller.marshal(value.getStatus()));
        result.add(COMPLETE, this.booleanMarshaller.marshal(value.isComplete()));
        result.add(REQUEST_URL, this.uriMarshaller.marshal(value.getRequestUrl()));
        return result;
    }

    @Override
    JsonBuildStatus nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        JsonObject object = this.asJsonObject(element);
        Long id = (Long)this.nonNull(this.longMarshaller.unmarshal(object.get(ID)));
        URI url = (URI)this.nonNull(this.uriMarshaller.unmarshal(object.get(URL)));
        String status = (String)this.nonNull(this.stringMarshaller.unmarshal(object.get(STATUS)));
        Boolean complete = (Boolean)this.nonNull(this.booleanMarshaller.unmarshal(object.get(COMPLETE)));
        URI requestUrl = (URI)this.nonNull(this.uriMarshaller.unmarshal(object.get(REQUEST_URL)));
        return new JsonBuildStatus(id, url, status, complete, requestUrl);
    }
}

