/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonElement;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;
import com.urbancode.ubuild.preflight.json.marshaller.StringMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongMarshaller
extends MarshallerBase<Long> {
    private final StringMarshaller stringMarshaller = new StringMarshaller();

    @Override
    JsonElement nonNullMarshal(Long value) {
        return this.stringMarshaller.marshal(value.toString());
    }

    @Override
    Long nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        Long result;
        try {
            result = Long.parseLong((String)this.stringMarshaller.unmarshal(element));
        }
        catch (NumberFormatException e) {
            throw new JsonFormatException("element is not a long: " + e.getMessage(), e);
        }
        return result;
    }
}

