/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.fileserver.protocol.messages;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

final class LatchedInputStream
extends FilterInputStream {
    private static final Logger log = Logger.getLogger(LatchedInputStream.class);
    private final CountDownLatch latch = new CountDownLatch(1);

    LatchedInputStream(InputStream in) {
        super(in);
    }

    public void awaitClose() throws InterruptedException {
        this.latch.await();
    }

    public boolean awaitClose(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.latch.countDown();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Signaled close");
            }
        }
    }
}

