/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata;

import com.urbancode.commons.util.Check;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata.FileMetadataCode;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum KnownFileMetadataCode implements FileMetadataCode
{
    UNIX_PERMISSIONS("UPRM"),
    MODIFIED_DATE("MDAT");

    private static final int[] sortedCodes;
    private static final KnownFileMetadataCode[] instancesSortedByCode;
    private final int code;

    public static KnownFileMetadataCode fromInt(int code) {
        int index = Arrays.binarySearch(sortedCodes, code);
        KnownFileMetadataCode result = index < 0 ? null : instancesSortedByCode[index];
        return result;
    }

    public static boolean isValidCode(int code) {
        return Arrays.binarySearch(sortedCodes, code) >= 0;
    }

    public static String decode(int code) {
        char[] buffer = new char[]{(char)(code >> 24 & 0xFF), (char)(code >> 16 & 0xFF), (char)(code >> 8 & 0xFF), (char)(code >> 0 & 0xFF)};
        return new String(buffer);
    }

    private static int encode(String code) {
        char[] buffer;
        int result = 0;
        Check.nonNull((Object)code, (String)"code");
        if (code.length() != 4) {
            throw new IllegalArgumentException("Invalid code length");
        }
        for (char c : buffer = code.toCharArray()) {
            if (c >= 'A' && c <= 'Z') continue;
            throw new IllegalArgumentException("Invalid code character");
        }
        result |= buffer[0] << 24;
        result |= buffer[1] << 16;
        result |= buffer[2] << 8;
        return result |= buffer[3] << 0;
    }

    private KnownFileMetadataCode(int code) {
        this.code = code;
    }

    private KnownFileMetadataCode(String string2) {
        this(KnownFileMetadataCode.encode(string2));
    }

    @Override
    public int toInt() {
        return this.code;
    }

    static {
        Comparator<KnownFileMetadataCode> comparator = new Comparator<KnownFileMetadataCode>(){

            @Override
            public int compare(KnownFileMetadataCode l, KnownFileMetadataCode r) {
                Integer lCode = l.toInt();
                Integer rCode = r.toInt();
                return lCode.compareTo(rCode);
            }
        };
        instancesSortedByCode = KnownFileMetadataCode.values();
        sortedCodes = new int[instancesSortedByCode.length];
        Arrays.sort(instancesSortedByCode, comparator);
        for (int i = 0; i < instancesSortedByCode.length; ++i) {
            KnownFileMetadataCode.sortedCodes[i] = instancesSortedByCode[i].toInt();
        }
    }
}

