/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.json.marshaller;

import com.google.gson.JsonElement;
import com.urbancode.ubuild.preflight.json.marshaller.JsonFormatException;
import com.urbancode.ubuild.preflight.json.marshaller.MarshallerBase;
import com.urbancode.ubuild.preflight.json.marshaller.StringMarshaller;
import java.net.URI;
import java.net.URISyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriMarshaller
extends MarshallerBase<URI> {
    private final StringMarshaller stringMarshaller = new StringMarshaller();

    @Override
    JsonElement nonNullMarshal(URI value) {
        return this.stringMarshaller.marshal(value.toASCIIString());
    }

    @Override
    URI nonNullUnmarshal(JsonElement element) throws JsonFormatException {
        URI result;
        try {
            String uri = (String)this.nonNull(this.stringMarshaller.unmarshal(element));
            result = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new JsonFormatException(e.getMessage(), e);
        }
        return result;
    }
}

