/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.model;

import com.urbancode.commons.util.Check;
import com.urbancode.ubuild.preflight.model.SyntaxException;
import java.net.MalformedURLException;
import java.net.URL;

public class UBuildUrl {
    private final URL url;

    public UBuildUrl(String urlText) throws UBuildUrlSyntaxException {
        URL url;
        Check.nonBlank((CharSequence)urlText, (String)"urlText");
        try {
            url = new URL(urlText);
        }
        catch (MalformedURLException e) {
            String message = e.getMessage();
            if (message == null) {
                throw new UBuildUrlSyntaxException("Invalid ubuild URL: " + urlText, e);
            }
            throw new UBuildUrlSyntaxException("Invalid ubuild URL: " + message + ": " + urlText, e);
        }
        this.url = this.validateAndNormalizeUrl(url);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof UBuildUrl) {
            UBuildUrl rhs = (UBuildUrl)obj;
            result = this.url.equals(rhs.url);
        }
        return result;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url.toString();
    }

    public String getProtocol() {
        return this.url.getProtocol();
    }

    public String getHost() {
        return this.url.getHost();
    }

    public int getPort() {
        return this.url.getPort();
    }

    public String getPath() {
        return this.url.getPath();
    }

    public String appendPath(String path) {
        String result;
        Check.nonNull((Object)path, (String)"path");
        String currentPath = this.getPath();
        currentPath = currentPath.replaceAll("/+$", "");
        path = path.replaceAll("^/+", "");
        String newPath = currentPath + "/" + path;
        try {
            result = new URL(this.getProtocol(), this.getHost(), this.getPort(), newPath).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to update path", e);
        }
        return result;
    }

    private URL validateAndNormalizeUrl(URL url) throws UBuildUrlSyntaxException {
        String protocol = url.getProtocol();
        if (!"http".equals(protocol) && !"https".equals(protocol)) {
            throw new UBuildUrlSyntaxException("Only \"http\" and \"https\" protocols supported");
        }
        String host = url.getHost();
        if (host == null || host.trim().length() == 0) {
            throw new UBuildUrlSyntaxException("A host is required");
        }
        int port = url.getPort();
        if (port == -1) {
            port = "http".equals(protocol) ? 80 : 443;
            try {
                url = new URL(protocol, host, port, url.getFile());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to update port", e);
            }
        }
        if (port <= 0 || port > 65535) {
            throw new UBuildUrlSyntaxException("Invalid port number");
        }
        String path = url.getPath();
        if (path.trim().length() == 0) {
            try {
                url = new URL(protocol, host, port, "/");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to update path", e);
            }
        }
        if (url.getRef() != null) {
            throw new UBuildUrlSyntaxException("Anchors are not permitted");
        }
        if (url.getQuery() != null) {
            throw new UBuildUrlSyntaxException("Query parameters are not permitted");
        }
        if (url.getUserInfo() != null) {
            throw new UBuildUrlSyntaxException("User info is not permitted");
        }
        return url;
    }

    public static class UBuildUrlSyntaxException
    extends SyntaxException {
        private static final long serialVersionUID = 1L;

        public UBuildUrlSyntaxException() {
        }

        public UBuildUrlSyntaxException(String message, Throwable cause) {
            super(message, cause);
        }

        public UBuildUrlSyntaxException(String message) {
            super(message);
        }

        public UBuildUrlSyntaxException(Throwable cause) {
            super(cause);
        }
    }
}

