/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.plugin;

import com.urbancode.commons.util.IO;
import com.urbancode.ubuild.preflight.fileserver.PreflightFileClient;
import com.urbancode.ubuild.preflight.fileserver.protocol.FileTransferListener;
import com.urbancode.ubuild.preflight.plugin.InvalidPluginArgumentException;
import com.urbancode.ubuild.preflight.plugin.TransferFailedException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TransferArtifactsStep
implements FileTransferListener {
    private static final Logger log = Logger.getLogger(TransferArtifactsStep.class);
    private final String host;
    private final int port;

    public TransferArtifactsStep(String[] args) {
        if (args.length != 2) {
            throw new InvalidPluginArgumentException("Wrong number of arguments");
        }
        this.host = args[0].trim();
        if (this.host.length() == 0) {
            throw new InvalidPluginArgumentException("Invalid host: " + this.host);
        }
        try {
            this.port = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            throw new InvalidPluginArgumentException("Invalid port: " + args[1]);
        }
        if (this.port < 1 || this.port > 65535) {
            throw new InvalidPluginArgumentException("Invalid port: " + args[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        int result;
        boolean exceptionInProgress = true;
        PreflightFileClient client = new PreflightFileClient(this.host, this.port);
        try {
            client.sendArtifacts(IO.pwd(), (FileTransferListener)this);
            result = 0;
            exceptionInProgress = false;
        }
        catch (TransferFailedException e) {
            log.error(e.getMessage());
            if (log.isDebugEnabled()) {
                log.debug("STACKTRACE", e);
            }
            result = 1;
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
            if (log.isDebugEnabled()) {
                log.debug("STACKTRACE", e);
            }
            result = 1;
        }
        finally {
            IO.closeSafely((Closeable)client, exceptionInProgress);
        }
        return result;
    }

    public void receivedRemoteError(String message) throws IOException {
        throw new TransferFailedException(message);
    }

    public void fileSendStarted(String path, long size, File file) {
        log.info("Sending " + file.getAbsolutePath());
    }

    public void fileSendEnded(String path, long size, File file) {
        log.info("Send complete");
    }

    public void fileSendFailed(String path, long size, File file, IOException cause) {
        throw new TransferFailedException("Send failed for " + file.getAbsolutePath() + ": " + cause.getMessage(), cause);
    }

    public void fileReceiveStarted(String path, long size, File file) {
        log.warn("Unexpected event fileReceiveStarted");
    }

    public void fileReceiveEnded(String path, long size, File file) {
        log.warn("Unexpected event fileReceiveEnded");
    }

    public void fileReceiveFailed(String path, long size, File file, IOException cause) {
        log.warn("Unexpected event fileReceiveFailed");
    }
}

