/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.fileserver.protocol;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.ubuild.preflight.fileserver.protocol.FileStream;
import com.urbancode.ubuild.preflight.fileserver.protocol.ProtocolCode;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.AckHelloMessage;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.FileMessage;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.HelloMessage;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.LocalErrorMessage;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.Message;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.PathSetMessage;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.RemoteErrorMessage;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata.FileMetadata;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata.FileMetadataCode;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata.FileMetadataCodes;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata.KnownFileMetadataCode;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata.ModifiedDateFileMetadata;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata.UnixPermissionsFileMetadata;
import com.urbancode.ubuild.preflight.fileserver.protocol.messages.filemetadata.UnknownFileMetadata;
import com.urbancode.ubuild.preflight.model.PathOffset;
import com.urbancode.ubuild.preflight.model.PathPattern;
import com.urbancode.ubuild.preflight.model.PathSet;
import com.urbancode.ubuild.preflight.model.SyntaxException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class MessageMarshaller {
    private final DataInputStream in;
    private final DataOutputStream out;

    public MessageMarshaller(DataInputStream in, DataOutputStream out) {
        this.in = in;
        this.out = out;
    }

    public Message unmarshal() throws IOException {
        Message result;
        int value = ProtocolCode.EOF.toInt();
        try {
            value = this.in.readInt();
        }
        catch (EOFException e) {
            // empty catch block
        }
        ProtocolCode code = ProtocolCode.fromInt(value);
        switch (code) {
            case HELLO: {
                int version = this.in.readInt();
                result = new HelloMessage(version);
                break;
            }
            case ACK_HELLO: {
                int version = this.in.readInt();
                result = new AckHelloMessage(version);
                break;
            }
            case LOCAL_ERROR: {
                throw new IOException("Cannot receive a local error");
            }
            case FILE: {
                String path = this.in.readUTF().replace('/', File.separatorChar);
                long size = this.in.readLong();
                int metadataCount = this.in.readInt();
                ArrayList<UnixPermissionsFileMetadata> metadata = new ArrayList<UnixPermissionsFileMetadata>();
                for (int i = 0; i < metadataCount; ++i) {
                    FileMetadata metadatum;
                    FileMetadataCode metadataCode = FileMetadataCodes.fromInt(this.in.readInt());
                    int payloadSize = this.in.readInt();
                    if (metadataCode == KnownFileMetadataCode.UNIX_PERMISSIONS) {
                        short permissions = this.in.readShort();
                        metadatum = new UnixPermissionsFileMetadata(permissions);
                    } else if (metadataCode == KnownFileMetadataCode.MODIFIED_DATE) {
                        long modifiedDate = this.in.readLong();
                        metadatum = new ModifiedDateFileMetadata(modifiedDate);
                    } else {
                        byte[] payload = new byte[payloadSize];
                        this.in.readFully(payload);
                        metadatum = new UnknownFileMetadata(metadataCode, payload);
                    }
                    metadata.add((UnixPermissionsFileMetadata)metadatum);
                }
                result = new FileMessage(path, size, IO.limited((InputStream)this.in, (long)size), metadata);
                break;
            }
            case PATH_SET: {
                String offset = this.in.readUTF();
                int includeCount = this.in.readInt();
                ArrayList<String> includes = new ArrayList<String>();
                for (int i = 0; i < includeCount; ++i) {
                    includes.add(this.in.readUTF());
                }
                int excludeCount = this.in.readInt();
                ArrayList<String> excludes = new ArrayList<String>();
                for (int i = 0; i < excludeCount; ++i) {
                    excludes.add(this.in.readUTF());
                }
                try {
                    PathSet setPattern = new PathSet(new PathOffset(offset), PathPattern.toPathPatterns(includes), PathPattern.toPathPatterns(excludes));
                    result = new PathSetMessage(setPattern);
                    break;
                }
                catch (SyntaxException e) {
                    throw new IOException("Corrupt pathset pattern message");
                }
            }
            case REMOTE_ERROR: {
                String message = this.in.readUTF();
                result = new RemoteErrorMessage(message);
                break;
            }
            default: {
                result = new Message(code);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Message message) throws IOException {
        Check.nonNull((Object)message, (String)"message");
        this.out.writeInt(message.getCode().toInt());
        if (message instanceof LocalErrorMessage) {
            throw new IllegalArgumentException("Cannot send a local error");
        }
        if (message instanceof HelloMessage) {
            HelloMessage helloMessage = (HelloMessage)message;
            this.out.writeInt(helloMessage.getVersion());
        } else if (message instanceof AckHelloMessage) {
            AckHelloMessage ackHelloMessage = (AckHelloMessage)message;
            this.out.writeInt(ackHelloMessage.getVersion());
        } else if (message instanceof RemoteErrorMessage) {
            RemoteErrorMessage remoteErrorMessage = (RemoteErrorMessage)message;
            this.out.writeUTF(remoteErrorMessage.getMessage());
        } else if (message instanceof FileMessage) {
            FileMessage fileMessage = (FileMessage)message;
            FileStream stream = fileMessage.getFileStream();
            try {
                String normalizedPath = stream.getPath().replace(File.separatorChar, '/');
                this.out.writeUTF(normalizedPath);
                this.out.writeLong(stream.getSize());
                this.out.writeInt(fileMessage.getMetadata().size());
                for (FileMetadata fileMetadata : fileMessage.getMetadata()) {
                    if (fileMetadata == null) {
                        throw new IOException("Null metadata item");
                    }
                    this.out.writeInt(fileMetadata.getCode().toInt());
                    this.out.writeInt(fileMetadata.getPayloadSize());
                    if (fileMetadata instanceof UnixPermissionsFileMetadata) {
                        UnixPermissionsFileMetadata perms = (UnixPermissionsFileMetadata)fileMetadata;
                        this.out.writeShort(perms.getPermissions());
                        continue;
                    }
                    if (fileMetadata instanceof ModifiedDateFileMetadata) {
                        ModifiedDateFileMetadata date = (ModifiedDateFileMetadata)fileMetadata;
                        this.out.writeLong(date.getModifiedDate());
                        continue;
                    }
                    if (fileMetadata instanceof UnknownFileMetadata) {
                        UnknownFileMetadata unknown = (UnknownFileMetadata)fileMetadata;
                        this.out.write(unknown.getPayload());
                        continue;
                    }
                    throw new IOException("Unknown metadata type: " + fileMetadata.getClass());
                }
                stream.transferTo(this.out);
            }
            finally {
                stream.close();
            }
        } else if (message instanceof PathSetMessage) {
            PathSetMessage pathSetPatternMessage = (PathSetMessage)message;
            PathSet setPattern = pathSetPatternMessage.getSetPattern();
            this.out.writeUTF(setPattern.getOffset().toString());
            this.out.writeInt(setPattern.getIncludes().size());
            for (PathPattern pattern : setPattern.getIncludes()) {
                this.out.writeUTF(pattern.toString());
            }
            this.out.writeInt(setPattern.getExcludes().size());
            for (PathPattern pattern : setPattern.getExcludes()) {
                this.out.writeUTF(pattern.toString());
            }
        }
        this.out.flush();
    }
}

