/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ubuild.preflight.model;

import com.urbancode.commons.util.Check;
import com.urbancode.ubuild.preflight.model.SyntaxException;
import java.io.File;

public class PathOffset {
    public static final PathOffset NONE;
    private final String path;

    static String sanitize(String path) throws PathOffsetSyntaxException {
        int length;
        if (path == null) {
            throw new PathOffsetSyntaxException("Invalid path offset: path is undefined");
        }
        path = path.trim();
        if ((path = path.replace('\\', '/')).equals("..") || path.startsWith("../") || path.endsWith("/..") || path.contains("/../")) {
            throw new PathOffsetSyntaxException("Invalid path offset: relative paths not permitted: " + path);
        }
        do {
            length = path.length();
        } while ((path = path.replaceAll("/\\./", "/")).length() != length);
        path = path.replaceFirst("^\\./", "");
        path = path.replaceFirst("/\\.$", "");
        path = path.replaceAll("/+", "/");
        path = path.replaceFirst("^/", "");
        if ((path = path.replaceFirst("/$", "")).equals(".")) {
            path = "";
        }
        return path;
    }

    public PathOffset(String path) throws PathOffsetSyntaxException {
        this.path = PathOffset.sanitize(path);
    }

    public File translate(File base) {
        Check.nonNull((Object)base, (String)"base");
        File result = base;
        if (this.path.length() != 0) {
            result = new File(base, this.path);
        }
        return result;
    }

    public String toString() {
        return this.path;
    }

    static {
        try {
            NONE = new PathOffset("");
        }
        catch (PathOffsetSyntaxException impossible) {
            throw new AssertionError();
        }
    }

    public static class PathOffsetSyntaxException
    extends SyntaxException {
        private static final long serialVersionUID = 1L;

        public PathOffsetSyntaxException() {
        }

        public PathOffsetSyntaxException(String message) {
            super(message);
        }

        public PathOffsetSyntaxException(Throwable cause) {
            super(cause);
        }

        public PathOffsetSyntaxException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

