/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* (c) Copyright IBM Corporation 2012, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import java.text.SimpleDateFormat
import java.util.Date
import java.util.TimeZone

final def PLUGIN_HOME = System.getenv()['PLUGIN_HOME']
final def out = System.out
final def workDir = new File('.').canonicalFile

def addArg(def arg, def flag, def command) {
    if (arg != null && arg.trim() != "") {
        command.add("-" + flag);
        command.add(arg);
    }
}

final def stepProps = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    stepProps.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def baseTestPath = stepProps['baseTestPath'];
def webAppUrl = stepProps['webAppUrl'];
def resultBasePath = stepProps['resultBasePath'];
def browser = stepProps['browser'];
def failOnError = stepProps['failOnError'];
def failOnWarning = stepProps['failOnWarning'];

def cscriptExe = "cscript.exe"
if (new File("C:\\Windows\\SysWOW64").exists()) {
    cscriptExe = "C:\\Windows\\SysWOW64\\cscript.exe"
}

//------------------------------------------------------------------------------
// Build the command
//------------------------------------------------------------------------------

def command = []
command.add(cscriptExe)
command.add(PLUGIN_HOME + "\\run_qtp_tests.vbs")
command.add(baseTestPath);

addArg(webAppUrl, "w", command);
addArg(resultBasePath, "r", command);
addArg(browser, "b", command);
addArg(failOnError, "e", command);
addArg(failOnWarning, "f", command);

//------------------------------------------------------------------------------
// Execute the sub-process with the Jacob DLL in the classpath
//------------------------------------------------------------------------------

println "Running command " + command.join(' ');
def process = (command as String[]).execute()

process.consumeProcessOutput(out, out);

process.waitFor()

if (process.exitValue()) {
    System.exit(process.exitValue())
}
