import com.urbancode.air.*
import com.urbancode.air.plugin.automation.*

final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()

final String projectName = props['automation/projectName']
final String url = props['automation/url']
final String username = props['automation/username']
final String password = props['automation/password']
final String passScript = props['automation/passScript']

String defectPattern = props['defectPattern'] ?: ".*"

PublishDefectReport pdr = new PublishDefectReport()
pdr.projectName = projectName
pdr.url = url
pdr.username = username
pdr.password = password
pdr.passScript = passScript

pdr.defectPattern = defectPattern

pdr.execute(props, apTool)